/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.tools.java;

import dev.mccue.tools.ToolArguments;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class JavaArguments
extends ToolArguments {
    static String toArgumentString(Object o) {
        return o == null ? "" : o.toString();
    }

    public JavaArguments() {
    }

    public JavaArguments(Collection<? extends String> c) {
        super(c);
    }

    public JavaArguments mainClass(Object mainClass) {
        this.add(JavaArguments.toArgumentString(mainClass));
        return this;
    }

    public JavaArguments sourceFile(Object sourceFile) {
        this.add(JavaArguments.toArgumentString(sourceFile));
        return this;
    }

    public JavaArguments _jar(Object jar) {
        this.add("-jar");
        this.add(JavaArguments.toArgumentString(jar));
        return this;
    }

    public JavaArguments _m(Object module) {
        this.add("-m");
        this.add(JavaArguments.toArgumentString(module));
        return this;
    }

    public JavaArguments _m(Object module, Object mainClass) {
        this.add("-m");
        this.add(JavaArguments.toArgumentString(module) + "/" + JavaArguments.toArgumentString(mainClass));
        return this;
    }

    public JavaArguments __module(Object module) {
        this.add("--module");
        this.add(JavaArguments.toArgumentString(module));
        return this;
    }

    public JavaArguments __module(Object module, Object mainClass) {
        this.add("--module");
        this.add(JavaArguments.toArgumentString(module) + "/" + JavaArguments.toArgumentString(mainClass));
        return this;
    }

    public JavaArguments _cp(Object ... paths) {
        return this._cp(Arrays.asList(paths));
    }

    public JavaArguments _cp(List<?> paths) {
        this.add("-cp");
        this.add(paths.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments _classpath(Object ... paths) {
        return this._classpath(Arrays.asList(paths));
    }

    public JavaArguments _classpath(List<?> paths) {
        this.add("-classpath");
        this.add(paths.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments __class_path(Object ... paths) {
        return this.__class_path(Arrays.asList(paths));
    }

    public JavaArguments __class_path(List<?> paths) {
        this.add("--class-path");
        this.add(paths.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments _p(Object ... modules) {
        return this._p(Arrays.asList(modules));
    }

    public JavaArguments _p(List<?> modules) {
        this.add("-p");
        this.add(modules.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments __module_path(Object ... modules) {
        return this.__module_path(Arrays.asList(modules));
    }

    public JavaArguments __module_path(List<?> modules) {
        this.add("--module-path");
        this.add(modules.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments __upgrade_module_path(Object ... modules) {
        return this.__upgrade_module_path(Arrays.asList(modules));
    }

    public JavaArguments __upgrade_module_path(List<?> modules) {
        this.add("--upgrade-module-path");
        this.add(modules.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(File.pathSeparator)));
        return this;
    }

    public JavaArguments __add_modules(Object ... moduleNames) {
        return this.__add_modules(Arrays.asList(moduleNames));
    }

    public JavaArguments __add_modules(List<?> moduleNames) {
        this.add("--add-modules");
        this.add(moduleNames.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(",")));
        return this;
    }

    public JavaArguments __enable_native_access(Object ... moduleNames) {
        return this.__enable_native_access(Arrays.asList(moduleNames));
    }

    public JavaArguments __enable_native_access(List<?> moduleNames) {
        this.add("--enable-native-access");
        this.add(moduleNames.stream().map(JavaArguments::toArgumentString).collect(Collectors.joining(",")));
        return this;
    }

    public JavaArguments __list_modules() {
        this.add("--list-modules");
        return this;
    }

    public JavaArguments _d(Object moduleName) {
        this.add("-d");
        this.add(JavaArguments.toArgumentString(moduleName));
        return this;
    }

    public JavaArguments __describe_module(Object moduleName) {
        this.add("--describe-module");
        this.add(JavaArguments.toArgumentString(moduleName));
        return this;
    }

    public JavaArguments __dry_run() {
        this.add("--dry-run");
        return this;
    }

    public JavaArguments __validate_modules() {
        this.add("--validate-modules");
        return this;
    }

    public JavaArguments _D(Object name, Object value) {
        this.add("-D" + JavaArguments.toArgumentString(name) + "=" + JavaArguments.toArgumentString(value));
        return this;
    }

    public JavaArguments _version() {
        this.add("-version");
        return this;
    }

    public JavaArguments __version() {
        this.add("--version");
        return this;
    }

    public JavaArguments _showversion() {
        this.add("-showversion");
        return this;
    }

    public JavaArguments __show_version() {
        this.add("--show-version");
        return this;
    }

    public JavaArguments __show_module_resolution() {
        this.add("--show-module-resolution");
        return this;
    }

    public JavaArguments _h() {
        this.add("-h");
        return this;
    }

    public JavaArguments _help() {
        this.add("-help");
        return this;
    }

    public JavaArguments __help() {
        this.add("--help");
        return this;
    }

    public JavaArguments _X() {
        this.add("-X");
        return this;
    }

    public JavaArguments __help_extra() {
        this.add("--help-extra");
        return this;
    }

    public JavaArguments _splash(Object imagepath) {
        this.add("-splash" + JavaArguments.toArgumentString(imagepath));
        return this;
    }

    public JavaArguments __enable_preview() {
        this.add("--enable-preview");
        return this;
    }

    public JavaArguments _Xcheck_jni() {
        this.add("-Xcheck:jni");
        return this;
    }

    public JavaArguments _Xcomp() {
        this.add("-Xdiag");
        return this;
    }

    public JavaArguments _Xdiag() {
        this.add("-Xdiag");
        return this;
    }

    public JavaArguments _Xint() {
        this.add("-Xint");
        return this;
    }

    public JavaArguments _Xmixed() {
        this.add("-Xmixed");
        return this;
    }

    public JavaArguments _Xmn(Object size) {
        this.add("-Xmn" + JavaArguments.toArgumentString(size));
        return this;
    }

    public JavaArguments _Xms(Object size) {
        this.add("-Xms" + JavaArguments.toArgumentString(size));
        return this;
    }

    public JavaArguments _Xmx(Object size) {
        this.add("-Xmx" + JavaArguments.toArgumentString(size));
        return this;
    }

    public JavaArguments _Xss(Object size) {
        this.add("-Xss" + JavaArguments.toArgumentString(size));
        return this;
    }
}

