/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.tools;

import dev.mccue.tools.AbstractTool;
import dev.mccue.tools.ExitStatusException;
import dev.mccue.tools.Tool;
import dev.mccue.tools.ToolArguments;
import dev.mccue.tools.ToolRunner;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract non-sealed class AbstractToolRunner<Self extends AbstractToolRunner<Self, Arguments>, Arguments extends ToolArguments>
implements ToolRunner {
    protected final Arguments arguments;
    protected final Tool tool;
    private OutputStream redirectOutput;
    private OutputStream redirectError;
    private Consumer<? super String> echoCommand;

    protected AbstractToolRunner(Tool tool, Arguments arguments) {
        this.tool = tool;
        this.arguments = arguments;
        this.redirectOutput = null;
        this.redirectError = null;
        this.echoCommand = System.err::println;
    }

    @Override
    public final void run() throws ExitStatusException {
        String[] args = (String[])this.arguments.toArray(String[]::new);
        Tool tool = this.tool;
        Objects.requireNonNull(tool);
        Tool tool2 = tool;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractTool.class}, (Object)tool2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        AbstractTool abstractTool = (AbstractTool)tool2;
        abstractTool.run(args, this.redirectOutput, this.redirectError, this.echoCommand);
    }

    @Override
    public final void run(List<String> extraArguments) throws ExitStatusException {
        ((ArrayList)this.arguments).addAll(extraArguments);
        this.run();
    }

    @Override
    public final void run(String ... extraArguments) throws ExitStatusException {
        ((ArrayList)this.arguments).addAll(Arrays.asList(extraArguments));
        this.run();
    }

    public final Self redirectOutput(OutputStream outputStream) {
        this.redirectOutput = outputStream;
        return (Self)this;
    }

    public final Self redirectError(OutputStream outputStream) {
        this.redirectError = outputStream;
        return (Self)this;
    }

    public final Self echoCommand(boolean echoCommand) {
        if (echoCommand) {
            if (this.echoCommand == null) {
                this.echoCommand = System.err::println;
            }
        } else {
            this.echoCommand = null;
        }
        return (Self)this;
    }

    public final Self echoCommand(Consumer<? super String> consumer) {
        this.echoCommand = consumer;
        return (Self)this;
    }

    public final Arguments arguments() {
        return this.arguments;
    }

    public final Self arguments(Consumer<? super Arguments> consumer) {
        consumer.accept(this.arguments);
        return (Self)this;
    }
}

