/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.tools;

import dev.mccue.tools.AbstractTool;
import dev.mccue.tools.ExitStatusException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

final class SubprocessTool
extends AbstractTool {
    private final List<String> commandPrefix;
    private final File directory;

    SubprocessTool(List<String> commandPrefix, File directory) {
        this.commandPrefix = commandPrefix;
        this.directory = directory;
    }

    @Override
    public void run(String[] args) throws ExitStatusException {
        this.run(args, null, null, System.err::println);
    }

    @Override
    public void run(List<String> args) throws ExitStatusException {
        this.run((String[])args.toArray(String[]::new));
    }

    @Override
    void run(String[] arguments, OutputStream redirectOutput, OutputStream redirectError, Consumer<? super String> echoCommand) throws ExitStatusException {
        if (echoCommand != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.join((CharSequence)" ", this.commandPrefix));
            if (arguments.length != 0) {
                sb.append(" ");
                sb.append(String.join((CharSequence)" ", arguments));
            }
            echoCommand.accept(sb.toString());
        }
        ArrayList<String> allArgs = new ArrayList<String>(this.commandPrefix);
        allArgs.addAll(Arrays.asList(arguments));
        try {
            ProcessBuilder pb = new ProcessBuilder(allArgs);
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            pb.redirectError(ProcessBuilder.Redirect.PIPE);
            if (this.directory != null) {
                pb.directory(this.directory);
            }
            Process process = pb.start();
            Thread t1 = Thread.startVirtualThread(() -> {
                try {
                    process.getInputStream().transferTo(redirectOutput == null ? System.out : redirectOutput);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            Thread t2 = Thread.startVirtualThread(() -> {
                try {
                    process.getErrorStream().transferTo(redirectError == null ? System.err : redirectError);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            int exit = process.waitFor();
            ExitStatusException.throwOnFailure(exit);
            t1.join();
            t2.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

