/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.tools;

import dev.mccue.tools.AbstractTool;
import dev.mccue.tools.ExitStatusException;
import dev.mccue.tools.SubprocessTool;
import dev.mccue.tools.ToolProviderTool;
import dev.mccue.tools.ToolRunner;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.spi.ToolProvider;

public sealed interface Tool
permits AbstractTool {
    public void run(List<String> var1) throws ExitStatusException;

    public void run(String ... var1) throws ExitStatusException;

    public static Tool ofToolProvider(ToolProvider toolProvider) {
        return new ToolProviderTool(toolProvider);
    }

    public static Tool ofToolProvider(String toolProviderName) {
        return new ToolProviderTool(ToolProvider.findFirst(toolProviderName).orElseThrow());
    }

    public static Tool ofSubprocess(List<String> commandPrefix) {
        return Tool.ofSubprocess(commandPrefix, (File)null);
    }

    public static Tool ofSubprocess(String commandPrefix) {
        return Tool.ofSubprocess(commandPrefix, (File)null);
    }

    public static Tool ofSubprocess(List<String> commandPrefix, Path directory) {
        return Tool.ofSubprocess(commandPrefix, directory.toFile());
    }

    public static Tool ofSubprocess(String commandPrefix, Path directory) {
        return Tool.ofSubprocess(commandPrefix, directory.toFile());
    }

    public static Tool ofSubprocess(List<String> commandPrefix, File directory) {
        return new SubprocessTool(commandPrefix, directory);
    }

    public static Tool ofSubprocess(String commandPrefix, File directory) {
        return new SubprocessTool(List.of(commandPrefix), directory);
    }

    default public ToolRunner runner() {
        return ToolRunner.of(this);
    }
}

