/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.tools;

import dev.mccue.tools.AbstractTool;
import dev.mccue.tools.ExitStatusException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.spi.ToolProvider;

final class ToolProviderTool
extends AbstractTool {
    private final ToolProvider toolProvider;

    ToolProviderTool(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    @Override
    public void run(String[] args) throws ExitStatusException {
        this.run(args, null, null, System.err::println);
    }

    @Override
    public void run(List<String> args) throws ExitStatusException {
        this.run((String[])args.toArray(String[]::new));
    }

    @Override
    void run(String[] arguments, OutputStream redirectOutput, OutputStream redirectError, Consumer<? super String> echoCommand) throws ExitStatusException {
        if (echoCommand != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toolProvider.name());
            if (arguments.length != 0) {
                sb.append(" ");
                sb.append(String.join((CharSequence)" ", arguments));
            }
            echoCommand.accept(sb.toString());
        }
        ExitStatusException.throwOnFailure(this.toolProvider.run(redirectOutput == null ? System.out : new PrintStream(redirectOutput), redirectError == null ? System.err : new PrintStream(redirectError), arguments));
    }
}

