/*
 * Decompiled with CFR 0.152.
 */
package dev.medzik.libcrypto;

import dev.medzik.libcrypto.AesException;
import dev.medzik.libcrypto.Hex;
import dev.medzik.libcrypto.Random;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Aes {
    private static final String ALGORITHM = "AES";
    public static final AesType GCM = AesType.GCM;
    public static final AesType CBC = AesType.CBC;

    public static String encrypt(AesType type, byte[] key, byte[] clearBytes) throws AesException {
        byte[] cipherBytes;
        Cipher cipher;
        byte[] iv = Random.randBytes(type.getIvLength());
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
        AlgorithmParameterSpec parameterSpec = Aes.getParameterSpec(type, iv);
        try {
            cipher = Cipher.getInstance(type.getMode());
            cipher.init(1, (Key)secretKey, parameterSpec);
        }
        catch (Exception e) {
            throw new AesException("Failed to init cipher", e);
        }
        try {
            cipherBytes = cipher.doFinal(clearBytes);
        }
        catch (Exception e) {
            throw new AesException("Failed to finalize encryption", e);
        }
        return Hex.encode(iv) + Hex.encode(cipherBytes);
    }

    public static byte[] decrypt(AesType type, byte[] key, String cipherText) throws AesException {
        Cipher cipher;
        int ivLength = type.getIvLength() * 2;
        byte[] iv = Hex.decode(cipherText.substring(0, ivLength));
        byte[] cipherBytes = Hex.decode(cipherText.substring(ivLength));
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
        AlgorithmParameterSpec parameterSpec = Aes.getParameterSpec(type, iv);
        try {
            cipher = Cipher.getInstance(type.getMode());
            cipher.init(2, (Key)secretKey, parameterSpec);
        }
        catch (Exception e) {
            throw new AesException("Failed to init cipher", e);
        }
        try {
            return cipher.doFinal(cipherBytes);
        }
        catch (Exception e) {
            throw new AesException("Failed to finalize decryption", e);
        }
    }

    private static AlgorithmParameterSpec getParameterSpec(AesType type, byte[] iv) {
        switch (type) {
            case CBC: {
                return new IvParameterSpec(iv);
            }
            case GCM: {
                return new GCMParameterSpec(128, iv);
            }
        }
        return null;
    }

    public static enum AesType {
        CBC("AES/CBC/PKCS5Padding", 16),
        GCM("AES/GCM/NoPadding", 12);

        private final String mode;
        private final int ivLength;

        private AesType(String mode, int ivLength) {
            this.mode = mode;
            this.ivLength = ivLength;
        }

        private String getMode() {
            return this.mode;
        }

        private int getIvLength() {
            return this.ivLength;
        }
    }
}

