/*
 * Decompiled with CFR 0.152.
 */
package dev.medzik.libcrypto;

import dev.medzik.libcrypto.Argon2EncodingUtils;
import dev.medzik.libcrypto.Argon2Type;

public final class Argon2Hash {
    private final Argon2Type type;
    private final int version;
    private final int memory;
    private final int iterations;
    private final int parallelism;
    private final byte[] salt;
    private final byte[] hash;

    public Argon2Hash(Argon2Type type, int version, int memory, int iterations, int parallelism, byte[] salt, byte[] hash) {
        this.type = type;
        this.version = version;
        this.memory = memory;
        this.iterations = iterations;
        this.parallelism = parallelism;
        this.salt = salt;
        this.hash = hash;
    }

    public Argon2Type getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public int getHashLength() {
        return this.hash.length;
    }

    public String toArgon2String() {
        return Argon2EncodingUtils.encode(this);
    }

    public String toString() {
        return this.toArgon2String();
    }
}

