/*
 * Decompiled with CFR 0.152.
 */
package dev.medzik.libcrypto;

import java.security.InvalidKeyException;
import java.security.SecureRandom;

public final class X25519 {
    public static byte[] generatePrivateKey() {
        byte[] privateKey = new byte[32];
        org.bouncycastle.math.ec.rfc7748.X25519.generatePrivateKey((SecureRandom)new SecureRandom(), (byte[])privateKey);
        return privateKey;
    }

    public static byte[] computeSharedSecret(byte[] ourPrivate, byte[] theirPublic) throws InvalidKeyException {
        if (ourPrivate.length != 32) {
            throw new InvalidKeyException("Private key must have 32 bytes.");
        }
        if (theirPublic.length != 32) {
            throw new InvalidKeyException("Public key must have 32 bytes.");
        }
        byte[] encoded = new byte[32];
        org.bouncycastle.math.ec.rfc7748.X25519.calculateAgreement((byte[])ourPrivate, (int)0, (byte[])theirPublic, (int)0, (byte[])encoded, (int)0);
        return encoded;
    }

    public static byte[] publicFromPrivate(byte[] privateKey) throws InvalidKeyException {
        if (privateKey.length != 32) {
            throw new InvalidKeyException("Private key must have 32 bytes.");
        }
        byte[] publicKey = new byte[32];
        org.bouncycastle.math.ec.rfc7748.X25519.generatePublicKey((byte[])privateKey, (int)0, (byte[])publicKey, (int)0);
        return publicKey;
    }
}

