/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.ats.applications.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ApplicationsMetaPostRetrieveRequest.Builder.class)
public final class ApplicationsMetaPostRetrieveRequest {
    private final Optional<String> applicationRemoteTemplateId;

    private final Map<String, Object> additionalProperties;

    private ApplicationsMetaPostRetrieveRequest(
            Optional<String> applicationRemoteTemplateId, Map<String, Object> additionalProperties) {
        this.applicationRemoteTemplateId = applicationRemoteTemplateId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The template ID associated with the nested application in the request.
     */
    @JsonProperty("application_remote_template_id")
    public Optional<String> getApplicationRemoteTemplateId() {
        return applicationRemoteTemplateId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ApplicationsMetaPostRetrieveRequest
                && equalTo((ApplicationsMetaPostRetrieveRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApplicationsMetaPostRetrieveRequest other) {
        return applicationRemoteTemplateId.equals(other.applicationRemoteTemplateId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.applicationRemoteTemplateId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> applicationRemoteTemplateId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ApplicationsMetaPostRetrieveRequest other) {
            applicationRemoteTemplateId(other.getApplicationRemoteTemplateId());
            return this;
        }

        @JsonSetter(value = "application_remote_template_id", nulls = Nulls.SKIP)
        public Builder applicationRemoteTemplateId(Optional<String> applicationRemoteTemplateId) {
            this.applicationRemoteTemplateId = applicationRemoteTemplateId;
            return this;
        }

        public Builder applicationRemoteTemplateId(String applicationRemoteTemplateId) {
            this.applicationRemoteTemplateId = Optional.of(applicationRemoteTemplateId);
            return this;
        }

        public ApplicationsMetaPostRetrieveRequest build() {
            return new ApplicationsMetaPostRetrieveRequest(applicationRemoteTemplateId, additionalProperties);
        }
    }
}
