/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = AccountIntegration.Builder.class)
public final class AccountIntegration {
    private final String name;

    private final Optional<String> abbreviatedName;

    private final Optional<List<CategoriesEnum>> categories;

    private final Optional<String> image;

    private final Optional<String> squareImage;

    private final Optional<String> color;

    private final Optional<String> slug;

    private final Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls;

    private final Optional<String> webhookSetupGuideUrl;

    private final Optional<Map<String, JsonNode>> categoryBetaStatus;

    private final Map<String, Object> additionalProperties;

    private AccountIntegration(
            String name,
            Optional<String> abbreviatedName,
            Optional<List<CategoriesEnum>> categories,
            Optional<String> image,
            Optional<String> squareImage,
            Optional<String> color,
            Optional<String> slug,
            Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls,
            Optional<String> webhookSetupGuideUrl,
            Optional<Map<String, JsonNode>> categoryBetaStatus,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.abbreviatedName = abbreviatedName;
        this.categories = categories;
        this.image = image;
        this.squareImage = squareImage;
        this.color = color;
        this.slug = slug;
        this.apiEndpointsToDocumentationUrls = apiEndpointsToDocumentationUrls;
        this.webhookSetupGuideUrl = webhookSetupGuideUrl;
        this.categoryBetaStatus = categoryBetaStatus;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Company name.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return Optional. This shortened name appears in places with limited space, usually in conjunction with the platform's logo (e.g., Merge Link menu).&lt;br&gt;&lt;br&gt;Example: &lt;i&gt;Workforce Now (in lieu of ADP Workforce Now), SuccessFactors (in lieu of SAP SuccessFactors)&lt;/i&gt;
     */
    @JsonProperty("abbreviated_name")
    public Optional<String> getAbbreviatedName() {
        return abbreviatedName;
    }

    /**
     * @return Category or categories this integration belongs to. Multiple categories should be comma separated, i.e. [ats, hris].
     */
    @JsonProperty("categories")
    public Optional<List<CategoriesEnum>> getCategories() {
        return categories;
    }

    /**
     * @return Company logo in rectangular shape.
     */
    @JsonProperty("image")
    public Optional<String> getImage() {
        return image;
    }

    /**
     * @return Company logo in square shape.
     */
    @JsonProperty("square_image")
    public Optional<String> getSquareImage() {
        return squareImage;
    }

    /**
     * @return The color of this integration used for buttons and text throughout the app and landing pages. &lt;b&gt;Choose a darker, saturated color.&lt;/b&gt;
     */
    @JsonProperty("color")
    public Optional<String> getColor() {
        return color;
    }

    @JsonProperty("slug")
    public Optional<String> getSlug() {
        return slug;
    }

    /**
     * @return Mapping of API endpoints to documentation urls for support. Example: {'GET': [['/common-model-scopes', 'https://docs.merge.dev/accounting/common-model-scopes/#common_model_scopes_retrieve'],['/common-model-actions', 'https://docs.merge.dev/accounting/common-model-actions/#common_model_actions_retrieve']], 'POST': []}
     */
    @JsonProperty("api_endpoints_to_documentation_urls")
    public Optional<Map<String, JsonNode>> getApiEndpointsToDocumentationUrls() {
        return apiEndpointsToDocumentationUrls;
    }

    /**
     * @return Setup guide URL for third party webhook creation. Exposed in Merge Docs.
     */
    @JsonProperty("webhook_setup_guide_url")
    public Optional<String> getWebhookSetupGuideUrl() {
        return webhookSetupGuideUrl;
    }

    /**
     * @return Category or categories this integration is in beta status for.
     */
    @JsonProperty("category_beta_status")
    public Optional<Map<String, JsonNode>> getCategoryBetaStatus() {
        return categoryBetaStatus;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AccountIntegration && equalTo((AccountIntegration) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountIntegration other) {
        return name.equals(other.name)
                && abbreviatedName.equals(other.abbreviatedName)
                && categories.equals(other.categories)
                && image.equals(other.image)
                && squareImage.equals(other.squareImage)
                && color.equals(other.color)
                && slug.equals(other.slug)
                && apiEndpointsToDocumentationUrls.equals(other.apiEndpointsToDocumentationUrls)
                && webhookSetupGuideUrl.equals(other.webhookSetupGuideUrl)
                && categoryBetaStatus.equals(other.categoryBetaStatus);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.name,
                this.abbreviatedName,
                this.categories,
                this.image,
                this.squareImage,
                this.color,
                this.slug,
                this.apiEndpointsToDocumentationUrls,
                this.webhookSetupGuideUrl,
                this.categoryBetaStatus);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        _FinalStage name(String name);

        Builder from(AccountIntegration other);
    }

    public interface _FinalStage {
        AccountIntegration build();

        _FinalStage abbreviatedName(Optional<String> abbreviatedName);

        _FinalStage abbreviatedName(String abbreviatedName);

        _FinalStage categories(Optional<List<CategoriesEnum>> categories);

        _FinalStage categories(List<CategoriesEnum> categories);

        _FinalStage image(Optional<String> image);

        _FinalStage image(String image);

        _FinalStage squareImage(Optional<String> squareImage);

        _FinalStage squareImage(String squareImage);

        _FinalStage color(Optional<String> color);

        _FinalStage color(String color);

        _FinalStage slug(Optional<String> slug);

        _FinalStage slug(String slug);

        _FinalStage apiEndpointsToDocumentationUrls(Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls);

        _FinalStage apiEndpointsToDocumentationUrls(Map<String, JsonNode> apiEndpointsToDocumentationUrls);

        _FinalStage webhookSetupGuideUrl(Optional<String> webhookSetupGuideUrl);

        _FinalStage webhookSetupGuideUrl(String webhookSetupGuideUrl);

        _FinalStage categoryBetaStatus(Optional<Map<String, JsonNode>> categoryBetaStatus);

        _FinalStage categoryBetaStatus(Map<String, JsonNode> categoryBetaStatus);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private Optional<Map<String, JsonNode>> categoryBetaStatus = Optional.empty();

        private Optional<String> webhookSetupGuideUrl = Optional.empty();

        private Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls = Optional.empty();

        private Optional<String> slug = Optional.empty();

        private Optional<String> color = Optional.empty();

        private Optional<String> squareImage = Optional.empty();

        private Optional<String> image = Optional.empty();

        private Optional<List<CategoriesEnum>> categories = Optional.empty();

        private Optional<String> abbreviatedName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AccountIntegration other) {
            name(other.getName());
            abbreviatedName(other.getAbbreviatedName());
            categories(other.getCategories());
            image(other.getImage());
            squareImage(other.getSquareImage());
            color(other.getColor());
            slug(other.getSlug());
            apiEndpointsToDocumentationUrls(other.getApiEndpointsToDocumentationUrls());
            webhookSetupGuideUrl(other.getWebhookSetupGuideUrl());
            categoryBetaStatus(other.getCategoryBetaStatus());
            return this;
        }

        /**
         * <p>Company name.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(String name) {
            this.name = name;
            return this;
        }

        /**
         * <p>Category or categories this integration is in beta status for.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage categoryBetaStatus(Map<String, JsonNode> categoryBetaStatus) {
            this.categoryBetaStatus = Optional.of(categoryBetaStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "category_beta_status", nulls = Nulls.SKIP)
        public _FinalStage categoryBetaStatus(Optional<Map<String, JsonNode>> categoryBetaStatus) {
            this.categoryBetaStatus = categoryBetaStatus;
            return this;
        }

        /**
         * <p>Setup guide URL for third party webhook creation. Exposed in Merge Docs.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookSetupGuideUrl(String webhookSetupGuideUrl) {
            this.webhookSetupGuideUrl = Optional.of(webhookSetupGuideUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_setup_guide_url", nulls = Nulls.SKIP)
        public _FinalStage webhookSetupGuideUrl(Optional<String> webhookSetupGuideUrl) {
            this.webhookSetupGuideUrl = webhookSetupGuideUrl;
            return this;
        }

        /**
         * <p>Mapping of API endpoints to documentation urls for support. Example: {'GET': [['/common-model-scopes', 'https://docs.merge.dev/accounting/common-model-scopes/#common_model_scopes_retrieve'],['/common-model-actions', 'https://docs.merge.dev/accounting/common-model-actions/#common_model_actions_retrieve']], 'POST': []}</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage apiEndpointsToDocumentationUrls(Map<String, JsonNode> apiEndpointsToDocumentationUrls) {
            this.apiEndpointsToDocumentationUrls = Optional.of(apiEndpointsToDocumentationUrls);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "api_endpoints_to_documentation_urls", nulls = Nulls.SKIP)
        public _FinalStage apiEndpointsToDocumentationUrls(
                Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls) {
            this.apiEndpointsToDocumentationUrls = apiEndpointsToDocumentationUrls;
            return this;
        }

        @java.lang.Override
        public _FinalStage slug(String slug) {
            this.slug = Optional.of(slug);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "slug", nulls = Nulls.SKIP)
        public _FinalStage slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        /**
         * <p>The color of this integration used for buttons and text throughout the app and landing pages. &lt;b&gt;Choose a darker, saturated color.&lt;/b&gt;</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage color(String color) {
            this.color = Optional.of(color);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "color", nulls = Nulls.SKIP)
        public _FinalStage color(Optional<String> color) {
            this.color = color;
            return this;
        }

        /**
         * <p>Company logo in square shape.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage squareImage(String squareImage) {
            this.squareImage = Optional.of(squareImage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "square_image", nulls = Nulls.SKIP)
        public _FinalStage squareImage(Optional<String> squareImage) {
            this.squareImage = squareImage;
            return this;
        }

        /**
         * <p>Company logo in rectangular shape.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage image(String image) {
            this.image = Optional.of(image);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "image", nulls = Nulls.SKIP)
        public _FinalStage image(Optional<String> image) {
            this.image = image;
            return this;
        }

        /**
         * <p>Category or categories this integration belongs to. Multiple categories should be comma separated, i.e. [ats, hris].</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage categories(List<CategoriesEnum> categories) {
            this.categories = Optional.of(categories);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "categories", nulls = Nulls.SKIP)
        public _FinalStage categories(Optional<List<CategoriesEnum>> categories) {
            this.categories = categories;
            return this;
        }

        /**
         * <p>Optional. This shortened name appears in places with limited space, usually in conjunction with the platform's logo (e.g., Merge Link menu).&lt;br&gt;&lt;br&gt;Example: &lt;i&gt;Workforce Now (in lieu of ADP Workforce Now), SuccessFactors (in lieu of SAP SuccessFactors)&lt;/i&gt;</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage abbreviatedName(String abbreviatedName) {
            this.abbreviatedName = Optional.of(abbreviatedName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "abbreviated_name", nulls = Nulls.SKIP)
        public _FinalStage abbreviatedName(Optional<String> abbreviatedName) {
            this.abbreviatedName = abbreviatedName;
            return this;
        }

        @java.lang.Override
        public AccountIntegration build() {
            return new AccountIntegration(
                    name,
                    abbreviatedName,
                    categories,
                    image,
                    squareImage,
                    color,
                    slug,
                    apiEndpointsToDocumentationUrls,
                    webhookSetupGuideUrl,
                    categoryBetaStatus,
                    additionalProperties);
        }
    }
}
