/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = RemoteFieldClassForCustomObjectClass.Builder.class)
public final class RemoteFieldClassForCustomObjectClass {
    private final Optional<OffsetDateTime> createdAt;

    private final Optional<OffsetDateTime> modifiedAt;

    private final Optional<String> displayName;

    private final Optional<String> remoteKeyName;

    private final Optional<String> description;

    private final Optional<Boolean> isRequired;

    private final Optional<RemoteFieldClassForCustomObjectClassFieldType> fieldType;

    private final Optional<RemoteFieldClassForCustomObjectClassFieldFormat> fieldFormat;

    private final Optional<List<RemoteFieldClassForCustomObjectClassFieldChoicesItem>> fieldChoices;

    private final Optional<RemoteFieldClassForCustomObjectClassItemSchema> itemSchema;

    private final Map<String, Object> additionalProperties;

    private RemoteFieldClassForCustomObjectClass(
            Optional<OffsetDateTime> createdAt,
            Optional<OffsetDateTime> modifiedAt,
            Optional<String> displayName,
            Optional<String> remoteKeyName,
            Optional<String> description,
            Optional<Boolean> isRequired,
            Optional<RemoteFieldClassForCustomObjectClassFieldType> fieldType,
            Optional<RemoteFieldClassForCustomObjectClassFieldFormat> fieldFormat,
            Optional<List<RemoteFieldClassForCustomObjectClassFieldChoicesItem>> fieldChoices,
            Optional<RemoteFieldClassForCustomObjectClassItemSchema> itemSchema,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.displayName = displayName;
        this.remoteKeyName = remoteKeyName;
        this.description = description;
        this.isRequired = isRequired;
        this.fieldType = fieldType;
        this.fieldFormat = fieldFormat;
        this.fieldChoices = fieldChoices;
        this.itemSchema = itemSchema;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The datetime that this object was created by Merge.
     */
    @JsonProperty("created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The datetime that this object was modified by Merge.
     */
    @JsonProperty("modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return modifiedAt;
    }

    @JsonProperty("display_name")
    public Optional<String> getDisplayName() {
        return displayName;
    }

    @JsonProperty("remote_key_name")
    public Optional<String> getRemoteKeyName() {
        return remoteKeyName;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("is_required")
    public Optional<Boolean> getIsRequired() {
        return isRequired;
    }

    @JsonProperty("field_type")
    public Optional<RemoteFieldClassForCustomObjectClassFieldType> getFieldType() {
        return fieldType;
    }

    @JsonProperty("field_format")
    public Optional<RemoteFieldClassForCustomObjectClassFieldFormat> getFieldFormat() {
        return fieldFormat;
    }

    @JsonProperty("field_choices")
    public Optional<List<RemoteFieldClassForCustomObjectClassFieldChoicesItem>> getFieldChoices() {
        return fieldChoices;
    }

    @JsonProperty("item_schema")
    public Optional<RemoteFieldClassForCustomObjectClassItemSchema> getItemSchema() {
        return itemSchema;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RemoteFieldClassForCustomObjectClass
                && equalTo((RemoteFieldClassForCustomObjectClass) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteFieldClassForCustomObjectClass other) {
        return createdAt.equals(other.createdAt)
                && modifiedAt.equals(other.modifiedAt)
                && displayName.equals(other.displayName)
                && remoteKeyName.equals(other.remoteKeyName)
                && description.equals(other.description)
                && isRequired.equals(other.isRequired)
                && fieldType.equals(other.fieldType)
                && fieldFormat.equals(other.fieldFormat)
                && fieldChoices.equals(other.fieldChoices)
                && itemSchema.equals(other.itemSchema);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.modifiedAt,
                this.displayName,
                this.remoteKeyName,
                this.description,
                this.isRequired,
                this.fieldType,
                this.fieldFormat,
                this.fieldChoices,
                this.itemSchema);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();

        private Optional<OffsetDateTime> modifiedAt = Optional.empty();

        private Optional<String> displayName = Optional.empty();

        private Optional<String> remoteKeyName = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<Boolean> isRequired = Optional.empty();

        private Optional<RemoteFieldClassForCustomObjectClassFieldType> fieldType = Optional.empty();

        private Optional<RemoteFieldClassForCustomObjectClassFieldFormat> fieldFormat = Optional.empty();

        private Optional<List<RemoteFieldClassForCustomObjectClassFieldChoicesItem>> fieldChoices = Optional.empty();

        private Optional<RemoteFieldClassForCustomObjectClassItemSchema> itemSchema = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(RemoteFieldClassForCustomObjectClass other) {
            createdAt(other.getCreatedAt());
            modifiedAt(other.getModifiedAt());
            displayName(other.getDisplayName());
            remoteKeyName(other.getRemoteKeyName());
            description(other.getDescription());
            isRequired(other.getIsRequired());
            fieldType(other.getFieldType());
            fieldFormat(other.getFieldFormat());
            fieldChoices(other.getFieldChoices());
            itemSchema(other.getItemSchema());
            return this;
        }

        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value = "modified_at", nulls = Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value = "display_name", nulls = Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.of(displayName);
            return this;
        }

        @JsonSetter(value = "remote_key_name", nulls = Nulls.SKIP)
        public Builder remoteKeyName(Optional<String> remoteKeyName) {
            this.remoteKeyName = remoteKeyName;
            return this;
        }

        public Builder remoteKeyName(String remoteKeyName) {
            this.remoteKeyName = Optional.of(remoteKeyName);
            return this;
        }

        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value = "is_required", nulls = Nulls.SKIP)
        public Builder isRequired(Optional<Boolean> isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = Optional.of(isRequired);
            return this;
        }

        @JsonSetter(value = "field_type", nulls = Nulls.SKIP)
        public Builder fieldType(Optional<RemoteFieldClassForCustomObjectClassFieldType> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder fieldType(RemoteFieldClassForCustomObjectClassFieldType fieldType) {
            this.fieldType = Optional.of(fieldType);
            return this;
        }

        @JsonSetter(value = "field_format", nulls = Nulls.SKIP)
        public Builder fieldFormat(Optional<RemoteFieldClassForCustomObjectClassFieldFormat> fieldFormat) {
            this.fieldFormat = fieldFormat;
            return this;
        }

        public Builder fieldFormat(RemoteFieldClassForCustomObjectClassFieldFormat fieldFormat) {
            this.fieldFormat = Optional.of(fieldFormat);
            return this;
        }

        @JsonSetter(value = "field_choices", nulls = Nulls.SKIP)
        public Builder fieldChoices(Optional<List<RemoteFieldClassForCustomObjectClassFieldChoicesItem>> fieldChoices) {
            this.fieldChoices = fieldChoices;
            return this;
        }

        public Builder fieldChoices(List<RemoteFieldClassForCustomObjectClassFieldChoicesItem> fieldChoices) {
            this.fieldChoices = Optional.of(fieldChoices);
            return this;
        }

        @JsonSetter(value = "item_schema", nulls = Nulls.SKIP)
        public Builder itemSchema(Optional<RemoteFieldClassForCustomObjectClassItemSchema> itemSchema) {
            this.itemSchema = itemSchema;
            return this;
        }

        public Builder itemSchema(RemoteFieldClassForCustomObjectClassItemSchema itemSchema) {
            this.itemSchema = Optional.of(itemSchema);
            return this;
        }

        public RemoteFieldClassForCustomObjectClass build() {
            return new RemoteFieldClassForCustomObjectClass(
                    createdAt,
                    modifiedAt,
                    displayName,
                    remoteKeyName,
                    description,
                    isRequired,
                    fieldType,
                    fieldFormat,
                    fieldChoices,
                    itemSchema,
                    additionalProperties);
        }
    }
}
