/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.hris.fieldmapping.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = RemoteFieldsRetrieveRequest.Builder.class)
public final class RemoteFieldsRetrieveRequest {
    private final Optional<String> commonModels;

    private final Optional<String> includeExampleValues;

    private final Map<String, Object> additionalProperties;

    private RemoteFieldsRetrieveRequest(
            Optional<String> commonModels,
            Optional<String> includeExampleValues,
            Map<String, Object> additionalProperties) {
        this.commonModels = commonModels;
        this.includeExampleValues = includeExampleValues;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A comma seperated list of Common Model names. If included, will only return Remote Fields for those Common Models.
     */
    @JsonProperty("common_models")
    public Optional<String> getCommonModels() {
        return commonModels;
    }

    /**
     * @return If true, will include example values, where available, for remote fields in the 3rd party platform. These examples come from active data from your customers.
     */
    @JsonProperty("include_example_values")
    public Optional<String> getIncludeExampleValues() {
        return includeExampleValues;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RemoteFieldsRetrieveRequest && equalTo((RemoteFieldsRetrieveRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteFieldsRetrieveRequest other) {
        return commonModels.equals(other.commonModels) && includeExampleValues.equals(other.includeExampleValues);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.commonModels, this.includeExampleValues);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> commonModels = Optional.empty();

        private Optional<String> includeExampleValues = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(RemoteFieldsRetrieveRequest other) {
            commonModels(other.getCommonModels());
            includeExampleValues(other.getIncludeExampleValues());
            return this;
        }

        @JsonSetter(value = "common_models", nulls = Nulls.SKIP)
        public Builder commonModels(Optional<String> commonModels) {
            this.commonModels = commonModels;
            return this;
        }

        public Builder commonModels(String commonModels) {
            this.commonModels = Optional.of(commonModels);
            return this;
        }

        @JsonSetter(value = "include_example_values", nulls = Nulls.SKIP)
        public Builder includeExampleValues(Optional<String> includeExampleValues) {
            this.includeExampleValues = includeExampleValues;
            return this;
        }

        public Builder includeExampleValues(String includeExampleValues) {
            this.includeExampleValues = Optional.of(includeExampleValues);
            return this;
        }

        public RemoteFieldsRetrieveRequest build() {
            return new RemoteFieldsRetrieveRequest(commonModels, includeExampleValues, additionalProperties);
        }
    }
}
