/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = AccountDetails.Builder.class)
public final class AccountDetails {
    private final Optional<String> id;

    private final Optional<String> integration;

    private final Optional<String> integrationSlug;

    private final Optional<CategoryEnum> category;

    private final Optional<String> endUserOriginId;

    private final Optional<String> endUserOrganizationName;

    private final Optional<String> endUserEmailAddress;

    private final Optional<String> status;

    private final Optional<String> webhookListenerUrl;

    private final Optional<Boolean> isDuplicate;

    private final Optional<String> accountType;

    private final Optional<OffsetDateTime> completedAt;

    private final Map<String, Object> additionalProperties;

    private AccountDetails(
            Optional<String> id,
            Optional<String> integration,
            Optional<String> integrationSlug,
            Optional<CategoryEnum> category,
            Optional<String> endUserOriginId,
            Optional<String> endUserOrganizationName,
            Optional<String> endUserEmailAddress,
            Optional<String> status,
            Optional<String> webhookListenerUrl,
            Optional<Boolean> isDuplicate,
            Optional<String> accountType,
            Optional<OffsetDateTime> completedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.integration = integration;
        this.integrationSlug = integrationSlug;
        this.category = category;
        this.endUserOriginId = endUserOriginId;
        this.endUserOrganizationName = endUserOrganizationName;
        this.endUserEmailAddress = endUserEmailAddress;
        this.status = status;
        this.webhookListenerUrl = webhookListenerUrl;
        this.isDuplicate = isDuplicate;
        this.accountType = accountType;
        this.completedAt = completedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    @JsonProperty("integration")
    public Optional<String> getIntegration() {
        return integration;
    }

    @JsonProperty("integration_slug")
    public Optional<String> getIntegrationSlug() {
        return integrationSlug;
    }

    @JsonProperty("category")
    public Optional<CategoryEnum> getCategory() {
        return category;
    }

    @JsonProperty("end_user_origin_id")
    public Optional<String> getEndUserOriginId() {
        return endUserOriginId;
    }

    @JsonProperty("end_user_organization_name")
    public Optional<String> getEndUserOrganizationName() {
        return endUserOrganizationName;
    }

    @JsonProperty("end_user_email_address")
    public Optional<String> getEndUserEmailAddress() {
        return endUserEmailAddress;
    }

    @JsonProperty("status")
    public Optional<String> getStatus() {
        return status;
    }

    @JsonProperty("webhook_listener_url")
    public Optional<String> getWebhookListenerUrl() {
        return webhookListenerUrl;
    }

    /**
     * @return Whether a Production Linked Account's credentials match another existing Production Linked Account. This field is <code>null</code> for Test Linked Accounts, incomplete Production Linked Accounts, and ignored duplicate Production Linked Account sets.
     */
    @JsonProperty("is_duplicate")
    public Optional<Boolean> getIsDuplicate() {
        return isDuplicate;
    }

    @JsonProperty("account_type")
    public Optional<String> getAccountType() {
        return accountType;
    }

    /**
     * @return The time at which account completes the linking flow.
     */
    @JsonProperty("completed_at")
    public Optional<OffsetDateTime> getCompletedAt() {
        return completedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AccountDetails && equalTo((AccountDetails) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountDetails other) {
        return id.equals(other.id)
                && integration.equals(other.integration)
                && integrationSlug.equals(other.integrationSlug)
                && category.equals(other.category)
                && endUserOriginId.equals(other.endUserOriginId)
                && endUserOrganizationName.equals(other.endUserOrganizationName)
                && endUserEmailAddress.equals(other.endUserEmailAddress)
                && status.equals(other.status)
                && webhookListenerUrl.equals(other.webhookListenerUrl)
                && isDuplicate.equals(other.isDuplicate)
                && accountType.equals(other.accountType)
                && completedAt.equals(other.completedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.integration,
                this.integrationSlug,
                this.category,
                this.endUserOriginId,
                this.endUserOrganizationName,
                this.endUserEmailAddress,
                this.status,
                this.webhookListenerUrl,
                this.isDuplicate,
                this.accountType,
                this.completedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<String> integration = Optional.empty();

        private Optional<String> integrationSlug = Optional.empty();

        private Optional<CategoryEnum> category = Optional.empty();

        private Optional<String> endUserOriginId = Optional.empty();

        private Optional<String> endUserOrganizationName = Optional.empty();

        private Optional<String> endUserEmailAddress = Optional.empty();

        private Optional<String> status = Optional.empty();

        private Optional<String> webhookListenerUrl = Optional.empty();

        private Optional<Boolean> isDuplicate = Optional.empty();

        private Optional<String> accountType = Optional.empty();

        private Optional<OffsetDateTime> completedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AccountDetails other) {
            id(other.getId());
            integration(other.getIntegration());
            integrationSlug(other.getIntegrationSlug());
            category(other.getCategory());
            endUserOriginId(other.getEndUserOriginId());
            endUserOrganizationName(other.getEndUserOrganizationName());
            endUserEmailAddress(other.getEndUserEmailAddress());
            status(other.getStatus());
            webhookListenerUrl(other.getWebhookListenerUrl());
            isDuplicate(other.getIsDuplicate());
            accountType(other.getAccountType());
            completedAt(other.getCompletedAt());
            return this;
        }

        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value = "integration", nulls = Nulls.SKIP)
        public Builder integration(Optional<String> integration) {
            this.integration = integration;
            return this;
        }

        public Builder integration(String integration) {
            this.integration = Optional.of(integration);
            return this;
        }

        @JsonSetter(value = "integration_slug", nulls = Nulls.SKIP)
        public Builder integrationSlug(Optional<String> integrationSlug) {
            this.integrationSlug = integrationSlug;
            return this;
        }

        public Builder integrationSlug(String integrationSlug) {
            this.integrationSlug = Optional.of(integrationSlug);
            return this;
        }

        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public Builder category(Optional<CategoryEnum> category) {
            this.category = category;
            return this;
        }

        public Builder category(CategoryEnum category) {
            this.category = Optional.of(category);
            return this;
        }

        @JsonSetter(value = "end_user_origin_id", nulls = Nulls.SKIP)
        public Builder endUserOriginId(Optional<String> endUserOriginId) {
            this.endUserOriginId = endUserOriginId;
            return this;
        }

        public Builder endUserOriginId(String endUserOriginId) {
            this.endUserOriginId = Optional.of(endUserOriginId);
            return this;
        }

        @JsonSetter(value = "end_user_organization_name", nulls = Nulls.SKIP)
        public Builder endUserOrganizationName(Optional<String> endUserOrganizationName) {
            this.endUserOrganizationName = endUserOrganizationName;
            return this;
        }

        public Builder endUserOrganizationName(String endUserOrganizationName) {
            this.endUserOrganizationName = Optional.of(endUserOrganizationName);
            return this;
        }

        @JsonSetter(value = "end_user_email_address", nulls = Nulls.SKIP)
        public Builder endUserEmailAddress(Optional<String> endUserEmailAddress) {
            this.endUserEmailAddress = endUserEmailAddress;
            return this;
        }

        public Builder endUserEmailAddress(String endUserEmailAddress) {
            this.endUserEmailAddress = Optional.of(endUserEmailAddress);
            return this;
        }

        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value = "webhook_listener_url", nulls = Nulls.SKIP)
        public Builder webhookListenerUrl(Optional<String> webhookListenerUrl) {
            this.webhookListenerUrl = webhookListenerUrl;
            return this;
        }

        public Builder webhookListenerUrl(String webhookListenerUrl) {
            this.webhookListenerUrl = Optional.of(webhookListenerUrl);
            return this;
        }

        @JsonSetter(value = "is_duplicate", nulls = Nulls.SKIP)
        public Builder isDuplicate(Optional<Boolean> isDuplicate) {
            this.isDuplicate = isDuplicate;
            return this;
        }

        public Builder isDuplicate(Boolean isDuplicate) {
            this.isDuplicate = Optional.of(isDuplicate);
            return this;
        }

        @JsonSetter(value = "account_type", nulls = Nulls.SKIP)
        public Builder accountType(Optional<String> accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = Optional.of(accountType);
            return this;
        }

        @JsonSetter(value = "completed_at", nulls = Nulls.SKIP)
        public Builder completedAt(Optional<OffsetDateTime> completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder completedAt(OffsetDateTime completedAt) {
            this.completedAt = Optional.of(completedAt);
            return this;
        }

        public AccountDetails build() {
            return new AccountDetails(
                    id,
                    integration,
                    integrationSlug,
                    category,
                    endUserOriginId,
                    endUserOrganizationName,
                    endUserEmailAddress,
                    status,
                    webhookListenerUrl,
                    isDuplicate,
                    accountType,
                    completedAt,
                    additionalProperties);
        }
    }
}
