/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = IndividualCommonModelScopeDeserializerRequest.Builder.class)
public final class IndividualCommonModelScopeDeserializerRequest {
    private final String modelName;

    private final Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions;

    private final Optional<FieldPermissionDeserializerRequest> fieldPermissions;

    private final Map<String, Object> additionalProperties;

    private IndividualCommonModelScopeDeserializerRequest(
            String modelName,
            Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions,
            Optional<FieldPermissionDeserializerRequest> fieldPermissions,
            Map<String, Object> additionalProperties) {
        this.modelName = modelName;
        this.modelPermissions = modelPermissions;
        this.fieldPermissions = fieldPermissions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("model_name")
    public String getModelName() {
        return modelName;
    }

    @JsonProperty("model_permissions")
    public Optional<Map<String, ModelPermissionDeserializerRequest>> getModelPermissions() {
        return modelPermissions;
    }

    @JsonProperty("field_permissions")
    public Optional<FieldPermissionDeserializerRequest> getFieldPermissions() {
        return fieldPermissions;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof IndividualCommonModelScopeDeserializerRequest
                && equalTo((IndividualCommonModelScopeDeserializerRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IndividualCommonModelScopeDeserializerRequest other) {
        return modelName.equals(other.modelName)
                && modelPermissions.equals(other.modelPermissions)
                && fieldPermissions.equals(other.fieldPermissions);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.modelName, this.modelPermissions, this.fieldPermissions);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelNameStage builder() {
        return new Builder();
    }

    public interface ModelNameStage {
        _FinalStage modelName(String modelName);

        Builder from(IndividualCommonModelScopeDeserializerRequest other);
    }

    public interface _FinalStage {
        IndividualCommonModelScopeDeserializerRequest build();

        _FinalStage modelPermissions(Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions);

        _FinalStage modelPermissions(Map<String, ModelPermissionDeserializerRequest> modelPermissions);

        _FinalStage fieldPermissions(Optional<FieldPermissionDeserializerRequest> fieldPermissions);

        _FinalStage fieldPermissions(FieldPermissionDeserializerRequest fieldPermissions);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ModelNameStage, _FinalStage {
        private String modelName;

        private Optional<FieldPermissionDeserializerRequest> fieldPermissions = Optional.empty();

        private Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(IndividualCommonModelScopeDeserializerRequest other) {
            modelName(other.getModelName());
            modelPermissions(other.getModelPermissions());
            fieldPermissions(other.getFieldPermissions());
            return this;
        }

        @java.lang.Override
        @JsonSetter("model_name")
        public _FinalStage modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @java.lang.Override
        public _FinalStage fieldPermissions(FieldPermissionDeserializerRequest fieldPermissions) {
            this.fieldPermissions = Optional.of(fieldPermissions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "field_permissions", nulls = Nulls.SKIP)
        public _FinalStage fieldPermissions(Optional<FieldPermissionDeserializerRequest> fieldPermissions) {
            this.fieldPermissions = fieldPermissions;
            return this;
        }

        @java.lang.Override
        public _FinalStage modelPermissions(Map<String, ModelPermissionDeserializerRequest> modelPermissions) {
            this.modelPermissions = Optional.of(modelPermissions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "model_permissions", nulls = Nulls.SKIP)
        public _FinalStage modelPermissions(
                Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions) {
            this.modelPermissions = modelPermissions;
            return this;
        }

        @java.lang.Override
        public IndividualCommonModelScopeDeserializerRequest build() {
            return new IndividualCommonModelScopeDeserializerRequest(
                    modelName, modelPermissions, fieldPermissions, additionalProperties);
        }
    }
}
