/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.audittrail.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AuditTrailListRequest {
    private final Optional<String> cursor;
    private final Optional<String> endDate;
    private final Optional<String> eventType;
    private final Optional<Integer> pageSize;
    private final Optional<String> startDate;
    private final Optional<String> userEmail;
    private final Map<String, Object> additionalProperties;

    private AuditTrailListRequest(Optional<String> cursor, Optional<String> endDate, Optional<String> eventType, Optional<Integer> pageSize, Optional<String> startDate, Optional<String> userEmail, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.endDate = endDate;
        this.eventType = eventType;
        this.pageSize = pageSize;
        this.startDate = startDate;
        this.userEmail = userEmail;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="end_date")
    public Optional<String> getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="event_type")
    public Optional<String> getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="start_date")
    public Optional<String> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="user_email")
    public Optional<String> getUserEmail() {
        return this.userEmail;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AuditTrailListRequest && this.equalTo((AuditTrailListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AuditTrailListRequest other) {
        return this.cursor.equals(other.cursor) && this.endDate.equals(other.endDate) && this.eventType.equals(other.eventType) && this.pageSize.equals(other.pageSize) && this.startDate.equals(other.startDate) && this.userEmail.equals(other.userEmail);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.endDate, this.eventType, this.pageSize, this.startDate, this.userEmail);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<String> endDate = Optional.empty();
        private Optional<String> eventType = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> startDate = Optional.empty();
        private Optional<String> userEmail = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AuditTrailListRequest other) {
            this.cursor(other.getCursor());
            this.endDate(other.getEndDate());
            this.eventType(other.getEventType());
            this.pageSize(other.getPageSize());
            this.startDate(other.getStartDate());
            this.userEmail(other.getUserEmail());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="end_date", nulls=Nulls.SKIP)
        public Builder endDate(Optional<String> endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = Optional.of(endDate);
            return this;
        }

        @JsonSetter(value="event_type", nulls=Nulls.SKIP)
        public Builder eventType(Optional<String> eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = Optional.of(eventType);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public Builder startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = Optional.of(startDate);
            return this;
        }

        @JsonSetter(value="user_email", nulls=Nulls.SKIP)
        public Builder userEmail(Optional<String> userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        public Builder userEmail(String userEmail) {
            this.userEmail = Optional.of(userEmail);
            return this;
        }

        public AuditTrailListRequest build() {
            return new AuditTrailListRequest(this.cursor, this.endDate, this.eventType, this.pageSize, this.startDate, this.userEmail, this.additionalProperties);
        }
    }
}

