/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.companyinfo.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.companyinfo.types.CompanyInfoRetrieveRequestExpand;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CompanyInfoRetrieveRequest {
    private final Optional<CompanyInfoRetrieveRequestExpand> expand;
    private final Optional<Boolean> includeRemoteData;
    private final Map<String, Object> additionalProperties;

    private CompanyInfoRetrieveRequest(Optional<CompanyInfoRetrieveRequestExpand> expand, Optional<Boolean> includeRemoteData, Map<String, Object> additionalProperties) {
        this.expand = expand;
        this.includeRemoteData = includeRemoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="expand")
    public Optional<CompanyInfoRetrieveRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyInfoRetrieveRequest && this.equalTo((CompanyInfoRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyInfoRetrieveRequest other) {
        return this.expand.equals(other.expand) && this.includeRemoteData.equals(other.includeRemoteData);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.includeRemoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CompanyInfoRetrieveRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CompanyInfoRetrieveRequest other) {
            this.expand(other.getExpand());
            this.includeRemoteData(other.getIncludeRemoteData());
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<CompanyInfoRetrieveRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(CompanyInfoRetrieveRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        public CompanyInfoRetrieveRequest build() {
            return new CompanyInfoRetrieveRequest(this.expand, this.includeRemoteData, this.additionalProperties);
        }
    }
}

