/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.contacts.types.ContactsListRequestExpand;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ContactsListRequest {
    private final Optional<String> companyId;
    private final Optional<OffsetDateTime> createdAfter;
    private final Optional<OffsetDateTime> createdBefore;
    private final Optional<String> cursor;
    private final Optional<ContactsListRequestExpand> expand;
    private final Optional<Boolean> includeDeletedData;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeRemoteFields;
    private final Optional<Boolean> includeShellData;
    private final Optional<String> isCustomer;
    private final Optional<String> isSupplier;
    private final Optional<OffsetDateTime> modifiedAfter;
    private final Optional<OffsetDateTime> modifiedBefore;
    private final Optional<Integer> pageSize;
    private final Optional<String> remoteFields;
    private final Optional<String> remoteId;
    private final Optional<String> showEnumOrigins;
    private final Map<String, Object> additionalProperties;

    private ContactsListRequest(Optional<String> companyId, Optional<OffsetDateTime> createdAfter, Optional<OffsetDateTime> createdBefore, Optional<String> cursor, Optional<ContactsListRequestExpand> expand, Optional<Boolean> includeDeletedData, Optional<Boolean> includeRemoteData, Optional<Boolean> includeRemoteFields, Optional<Boolean> includeShellData, Optional<String> isCustomer, Optional<String> isSupplier, Optional<OffsetDateTime> modifiedAfter, Optional<OffsetDateTime> modifiedBefore, Optional<Integer> pageSize, Optional<String> remoteFields, Optional<String> remoteId, Optional<String> showEnumOrigins, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.createdAfter = createdAfter;
        this.createdBefore = createdBefore;
        this.cursor = cursor;
        this.expand = expand;
        this.includeDeletedData = includeDeletedData;
        this.includeRemoteData = includeRemoteData;
        this.includeRemoteFields = includeRemoteFields;
        this.includeShellData = includeShellData;
        this.isCustomer = isCustomer;
        this.isSupplier = isSupplier;
        this.modifiedAfter = modifiedAfter;
        this.modifiedBefore = modifiedBefore;
        this.pageSize = pageSize;
        this.remoteFields = remoteFields;
        this.remoteId = remoteId;
        this.showEnumOrigins = showEnumOrigins;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_after")
    public Optional<OffsetDateTime> getCreatedAfter() {
        return this.createdAfter;
    }

    @JsonProperty(value="created_before")
    public Optional<OffsetDateTime> getCreatedBefore() {
        return this.createdBefore;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="expand")
    public Optional<ContactsListRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_deleted_data")
    public Optional<Boolean> getIncludeDeletedData() {
        return this.includeDeletedData;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_remote_fields")
    public Optional<Boolean> getIncludeRemoteFields() {
        return this.includeRemoteFields;
    }

    @JsonProperty(value="include_shell_data")
    public Optional<Boolean> getIncludeShellData() {
        return this.includeShellData;
    }

    @JsonProperty(value="is_customer")
    public Optional<String> getIsCustomer() {
        return this.isCustomer;
    }

    @JsonProperty(value="is_supplier")
    public Optional<String> getIsSupplier() {
        return this.isSupplier;
    }

    @JsonProperty(value="modified_after")
    public Optional<OffsetDateTime> getModifiedAfter() {
        return this.modifiedAfter;
    }

    @JsonProperty(value="modified_before")
    public Optional<OffsetDateTime> getModifiedBefore() {
        return this.modifiedBefore;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="remote_fields")
    public Optional<String> getRemoteFields() {
        return this.remoteFields;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="show_enum_origins")
    public Optional<String> getShowEnumOrigins() {
        return this.showEnumOrigins;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactsListRequest && this.equalTo((ContactsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactsListRequest other) {
        return this.companyId.equals(other.companyId) && this.createdAfter.equals(other.createdAfter) && this.createdBefore.equals(other.createdBefore) && this.cursor.equals(other.cursor) && this.expand.equals(other.expand) && this.includeDeletedData.equals(other.includeDeletedData) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeRemoteFields.equals(other.includeRemoteFields) && this.includeShellData.equals(other.includeShellData) && this.isCustomer.equals(other.isCustomer) && this.isSupplier.equals(other.isSupplier) && this.modifiedAfter.equals(other.modifiedAfter) && this.modifiedBefore.equals(other.modifiedBefore) && this.pageSize.equals(other.pageSize) && this.remoteFields.equals(other.remoteFields) && this.remoteId.equals(other.remoteId) && this.showEnumOrigins.equals(other.showEnumOrigins);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.createdAfter, this.createdBefore, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeRemoteFields, this.includeShellData, this.isCustomer, this.isSupplier, this.modifiedAfter, this.modifiedBefore, this.pageSize, this.remoteFields, this.remoteId, this.showEnumOrigins);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();
        private Optional<OffsetDateTime> createdAfter = Optional.empty();
        private Optional<OffsetDateTime> createdBefore = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<ContactsListRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeDeletedData = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeRemoteFields = Optional.empty();
        private Optional<Boolean> includeShellData = Optional.empty();
        private Optional<String> isCustomer = Optional.empty();
        private Optional<String> isSupplier = Optional.empty();
        private Optional<OffsetDateTime> modifiedAfter = Optional.empty();
        private Optional<OffsetDateTime> modifiedBefore = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> remoteFields = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<String> showEnumOrigins = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactsListRequest other) {
            this.companyId(other.getCompanyId());
            this.createdAfter(other.getCreatedAfter());
            this.createdBefore(other.getCreatedBefore());
            this.cursor(other.getCursor());
            this.expand(other.getExpand());
            this.includeDeletedData(other.getIncludeDeletedData());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeRemoteFields(other.getIncludeRemoteFields());
            this.includeShellData(other.getIncludeShellData());
            this.isCustomer(other.getIsCustomer());
            this.isSupplier(other.getIsSupplier());
            this.modifiedAfter(other.getModifiedAfter());
            this.modifiedBefore(other.getModifiedBefore());
            this.pageSize(other.getPageSize());
            this.remoteFields(other.getRemoteFields());
            this.remoteId(other.getRemoteId());
            this.showEnumOrigins(other.getShowEnumOrigins());
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.of(companyId);
            return this;
        }

        @JsonSetter(value="created_after", nulls=Nulls.SKIP)
        public Builder createdAfter(Optional<OffsetDateTime> createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public Builder createdAfter(OffsetDateTime createdAfter) {
            this.createdAfter = Optional.of(createdAfter);
            return this;
        }

        @JsonSetter(value="created_before", nulls=Nulls.SKIP)
        public Builder createdBefore(Optional<OffsetDateTime> createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public Builder createdBefore(OffsetDateTime createdBefore) {
            this.createdBefore = Optional.of(createdBefore);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<ContactsListRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(ContactsListRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_deleted_data", nulls=Nulls.SKIP)
        public Builder includeDeletedData(Optional<Boolean> includeDeletedData) {
            this.includeDeletedData = includeDeletedData;
            return this;
        }

        public Builder includeDeletedData(Boolean includeDeletedData) {
            this.includeDeletedData = Optional.of(includeDeletedData);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_remote_fields", nulls=Nulls.SKIP)
        public Builder includeRemoteFields(Optional<Boolean> includeRemoteFields) {
            this.includeRemoteFields = includeRemoteFields;
            return this;
        }

        public Builder includeRemoteFields(Boolean includeRemoteFields) {
            this.includeRemoteFields = Optional.of(includeRemoteFields);
            return this;
        }

        @JsonSetter(value="include_shell_data", nulls=Nulls.SKIP)
        public Builder includeShellData(Optional<Boolean> includeShellData) {
            this.includeShellData = includeShellData;
            return this;
        }

        public Builder includeShellData(Boolean includeShellData) {
            this.includeShellData = Optional.of(includeShellData);
            return this;
        }

        @JsonSetter(value="is_customer", nulls=Nulls.SKIP)
        public Builder isCustomer(Optional<String> isCustomer) {
            this.isCustomer = isCustomer;
            return this;
        }

        public Builder isCustomer(String isCustomer) {
            this.isCustomer = Optional.of(isCustomer);
            return this;
        }

        @JsonSetter(value="is_supplier", nulls=Nulls.SKIP)
        public Builder isSupplier(Optional<String> isSupplier) {
            this.isSupplier = isSupplier;
            return this;
        }

        public Builder isSupplier(String isSupplier) {
            this.isSupplier = Optional.of(isSupplier);
            return this;
        }

        @JsonSetter(value="modified_after", nulls=Nulls.SKIP)
        public Builder modifiedAfter(Optional<OffsetDateTime> modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public Builder modifiedAfter(OffsetDateTime modifiedAfter) {
            this.modifiedAfter = Optional.of(modifiedAfter);
            return this;
        }

        @JsonSetter(value="modified_before", nulls=Nulls.SKIP)
        public Builder modifiedBefore(Optional<OffsetDateTime> modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public Builder modifiedBefore(OffsetDateTime modifiedBefore) {
            this.modifiedBefore = Optional.of(modifiedBefore);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<String> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(String remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="show_enum_origins", nulls=Nulls.SKIP)
        public Builder showEnumOrigins(Optional<String> showEnumOrigins) {
            this.showEnumOrigins = showEnumOrigins;
            return this;
        }

        public Builder showEnumOrigins(String showEnumOrigins) {
            this.showEnumOrigins = Optional.of(showEnumOrigins);
            return this;
        }

        public ContactsListRequest build() {
            return new ContactsListRequest(this.companyId, this.createdAfter, this.createdBefore, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeRemoteFields, this.includeShellData, this.isCustomer, this.isSupplier, this.modifiedAfter, this.modifiedBefore, this.pageSize, this.remoteFields, this.remoteId, this.showEnumOrigins, this.additionalProperties);
        }
    }
}

