/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.contacts.types.ContactsRetrieveRequestExpand;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ContactsRetrieveRequest {
    private final Optional<ContactsRetrieveRequestExpand> expand;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeRemoteFields;
    private final Optional<String> remoteFields;
    private final Optional<String> showEnumOrigins;
    private final Map<String, Object> additionalProperties;

    private ContactsRetrieveRequest(Optional<ContactsRetrieveRequestExpand> expand, Optional<Boolean> includeRemoteData, Optional<Boolean> includeRemoteFields, Optional<String> remoteFields, Optional<String> showEnumOrigins, Map<String, Object> additionalProperties) {
        this.expand = expand;
        this.includeRemoteData = includeRemoteData;
        this.includeRemoteFields = includeRemoteFields;
        this.remoteFields = remoteFields;
        this.showEnumOrigins = showEnumOrigins;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="expand")
    public Optional<ContactsRetrieveRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_remote_fields")
    public Optional<Boolean> getIncludeRemoteFields() {
        return this.includeRemoteFields;
    }

    @JsonProperty(value="remote_fields")
    public Optional<String> getRemoteFields() {
        return this.remoteFields;
    }

    @JsonProperty(value="show_enum_origins")
    public Optional<String> getShowEnumOrigins() {
        return this.showEnumOrigins;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactsRetrieveRequest && this.equalTo((ContactsRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactsRetrieveRequest other) {
        return this.expand.equals(other.expand) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeRemoteFields.equals(other.includeRemoteFields) && this.remoteFields.equals(other.remoteFields) && this.showEnumOrigins.equals(other.showEnumOrigins);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.includeRemoteData, this.includeRemoteFields, this.remoteFields, this.showEnumOrigins);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ContactsRetrieveRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeRemoteFields = Optional.empty();
        private Optional<String> remoteFields = Optional.empty();
        private Optional<String> showEnumOrigins = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactsRetrieveRequest other) {
            this.expand(other.getExpand());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeRemoteFields(other.getIncludeRemoteFields());
            this.remoteFields(other.getRemoteFields());
            this.showEnumOrigins(other.getShowEnumOrigins());
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<ContactsRetrieveRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(ContactsRetrieveRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_remote_fields", nulls=Nulls.SKIP)
        public Builder includeRemoteFields(Optional<Boolean> includeRemoteFields) {
            this.includeRemoteFields = includeRemoteFields;
            return this;
        }

        public Builder includeRemoteFields(Boolean includeRemoteFields) {
            this.includeRemoteFields = Optional.of(includeRemoteFields);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<String> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(String remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        @JsonSetter(value="show_enum_origins", nulls=Nulls.SKIP)
        public Builder showEnumOrigins(Optional<String> showEnumOrigins) {
            this.showEnumOrigins = showEnumOrigins;
            return this;
        }

        public Builder showEnumOrigins(String showEnumOrigins) {
            this.showEnumOrigins = Optional.of(showEnumOrigins);
            return this;
        }

        public ContactsRetrieveRequest build() {
            return new ContactsRetrieveRequest(this.expand, this.includeRemoteData, this.includeRemoteFields, this.remoteFields, this.showEnumOrigins, this.additionalProperties);
        }
    }
}

