/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.expenses.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.expenses.types.ExpensesRetrieveRequestExpand;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExpensesRetrieveRequest {
    private final Optional<ExpensesRetrieveRequestExpand> expand;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeRemoteFields;
    private final Map<String, Object> additionalProperties;

    private ExpensesRetrieveRequest(Optional<ExpensesRetrieveRequestExpand> expand, Optional<Boolean> includeRemoteData, Optional<Boolean> includeRemoteFields, Map<String, Object> additionalProperties) {
        this.expand = expand;
        this.includeRemoteData = includeRemoteData;
        this.includeRemoteFields = includeRemoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="expand")
    public Optional<ExpensesRetrieveRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_remote_fields")
    public Optional<Boolean> getIncludeRemoteFields() {
        return this.includeRemoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExpensesRetrieveRequest && this.equalTo((ExpensesRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpensesRetrieveRequest other) {
        return this.expand.equals(other.expand) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeRemoteFields.equals(other.includeRemoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.includeRemoteData, this.includeRemoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ExpensesRetrieveRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeRemoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExpensesRetrieveRequest other) {
            this.expand(other.getExpand());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeRemoteFields(other.getIncludeRemoteFields());
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<ExpensesRetrieveRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(ExpensesRetrieveRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_remote_fields", nulls=Nulls.SKIP)
        public Builder includeRemoteFields(Optional<Boolean> includeRemoteFields) {
            this.includeRemoteFields = includeRemoteFields;
            return this;
        }

        public Builder includeRemoteFields(Boolean includeRemoteFields) {
            this.includeRemoteFields = Optional.of(includeRemoteFields);
            return this;
        }

        public ExpensesRetrieveRequest build() {
            return new ExpensesRetrieveRequest(this.expand, this.includeRemoteData, this.includeRemoteFields, this.additionalProperties);
        }
    }
}

