/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.issues.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.issues.types.IssuesListRequestStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class IssuesListRequest {
    private final Optional<String> accountToken;
    private final Optional<String> cursor;
    private final Optional<String> endDate;
    private final Optional<String> endUserOrganizationName;
    private final Optional<OffsetDateTime> firstIncidentTimeAfter;
    private final Optional<OffsetDateTime> firstIncidentTimeBefore;
    private final Optional<String> includeMuted;
    private final Optional<String> integrationName;
    private final Optional<OffsetDateTime> lastIncidentTimeAfter;
    private final Optional<OffsetDateTime> lastIncidentTimeBefore;
    private final Optional<String> linkedAccountId;
    private final Optional<Integer> pageSize;
    private final Optional<String> startDate;
    private final Optional<IssuesListRequestStatus> status;
    private final Map<String, Object> additionalProperties;

    private IssuesListRequest(Optional<String> accountToken, Optional<String> cursor, Optional<String> endDate, Optional<String> endUserOrganizationName, Optional<OffsetDateTime> firstIncidentTimeAfter, Optional<OffsetDateTime> firstIncidentTimeBefore, Optional<String> includeMuted, Optional<String> integrationName, Optional<OffsetDateTime> lastIncidentTimeAfter, Optional<OffsetDateTime> lastIncidentTimeBefore, Optional<String> linkedAccountId, Optional<Integer> pageSize, Optional<String> startDate, Optional<IssuesListRequestStatus> status, Map<String, Object> additionalProperties) {
        this.accountToken = accountToken;
        this.cursor = cursor;
        this.endDate = endDate;
        this.endUserOrganizationName = endUserOrganizationName;
        this.firstIncidentTimeAfter = firstIncidentTimeAfter;
        this.firstIncidentTimeBefore = firstIncidentTimeBefore;
        this.includeMuted = includeMuted;
        this.integrationName = integrationName;
        this.lastIncidentTimeAfter = lastIncidentTimeAfter;
        this.lastIncidentTimeBefore = lastIncidentTimeBefore;
        this.linkedAccountId = linkedAccountId;
        this.pageSize = pageSize;
        this.startDate = startDate;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_token")
    public Optional<String> getAccountToken() {
        return this.accountToken;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="end_date")
    public Optional<String> getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_user_organization_name")
    public Optional<String> getEndUserOrganizationName() {
        return this.endUserOrganizationName;
    }

    @JsonProperty(value="first_incident_time_after")
    public Optional<OffsetDateTime> getFirstIncidentTimeAfter() {
        return this.firstIncidentTimeAfter;
    }

    @JsonProperty(value="first_incident_time_before")
    public Optional<OffsetDateTime> getFirstIncidentTimeBefore() {
        return this.firstIncidentTimeBefore;
    }

    @JsonProperty(value="include_muted")
    public Optional<String> getIncludeMuted() {
        return this.includeMuted;
    }

    @JsonProperty(value="integration_name")
    public Optional<String> getIntegrationName() {
        return this.integrationName;
    }

    @JsonProperty(value="last_incident_time_after")
    public Optional<OffsetDateTime> getLastIncidentTimeAfter() {
        return this.lastIncidentTimeAfter;
    }

    @JsonProperty(value="last_incident_time_before")
    public Optional<OffsetDateTime> getLastIncidentTimeBefore() {
        return this.lastIncidentTimeBefore;
    }

    @JsonProperty(value="linked_account_id")
    public Optional<String> getLinkedAccountId() {
        return this.linkedAccountId;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="start_date")
    public Optional<String> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="status")
    public Optional<IssuesListRequestStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IssuesListRequest && this.equalTo((IssuesListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IssuesListRequest other) {
        return this.accountToken.equals(other.accountToken) && this.cursor.equals(other.cursor) && this.endDate.equals(other.endDate) && this.endUserOrganizationName.equals(other.endUserOrganizationName) && this.firstIncidentTimeAfter.equals(other.firstIncidentTimeAfter) && this.firstIncidentTimeBefore.equals(other.firstIncidentTimeBefore) && this.includeMuted.equals(other.includeMuted) && this.integrationName.equals(other.integrationName) && this.lastIncidentTimeAfter.equals(other.lastIncidentTimeAfter) && this.lastIncidentTimeBefore.equals(other.lastIncidentTimeBefore) && this.linkedAccountId.equals(other.linkedAccountId) && this.pageSize.equals(other.pageSize) && this.startDate.equals(other.startDate) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.accountToken, this.cursor, this.endDate, this.endUserOrganizationName, this.firstIncidentTimeAfter, this.firstIncidentTimeBefore, this.includeMuted, this.integrationName, this.lastIncidentTimeAfter, this.lastIncidentTimeBefore, this.linkedAccountId, this.pageSize, this.startDate, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> accountToken = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> endDate = Optional.empty();
        private Optional<String> endUserOrganizationName = Optional.empty();
        private Optional<OffsetDateTime> firstIncidentTimeAfter = Optional.empty();
        private Optional<OffsetDateTime> firstIncidentTimeBefore = Optional.empty();
        private Optional<String> includeMuted = Optional.empty();
        private Optional<String> integrationName = Optional.empty();
        private Optional<OffsetDateTime> lastIncidentTimeAfter = Optional.empty();
        private Optional<OffsetDateTime> lastIncidentTimeBefore = Optional.empty();
        private Optional<String> linkedAccountId = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> startDate = Optional.empty();
        private Optional<IssuesListRequestStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(IssuesListRequest other) {
            this.accountToken(other.getAccountToken());
            this.cursor(other.getCursor());
            this.endDate(other.getEndDate());
            this.endUserOrganizationName(other.getEndUserOrganizationName());
            this.firstIncidentTimeAfter(other.getFirstIncidentTimeAfter());
            this.firstIncidentTimeBefore(other.getFirstIncidentTimeBefore());
            this.includeMuted(other.getIncludeMuted());
            this.integrationName(other.getIntegrationName());
            this.lastIncidentTimeAfter(other.getLastIncidentTimeAfter());
            this.lastIncidentTimeBefore(other.getLastIncidentTimeBefore());
            this.linkedAccountId(other.getLinkedAccountId());
            this.pageSize(other.getPageSize());
            this.startDate(other.getStartDate());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="account_token", nulls=Nulls.SKIP)
        public Builder accountToken(Optional<String> accountToken) {
            this.accountToken = accountToken;
            return this;
        }

        public Builder accountToken(String accountToken) {
            this.accountToken = Optional.of(accountToken);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="end_date", nulls=Nulls.SKIP)
        public Builder endDate(Optional<String> endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = Optional.of(endDate);
            return this;
        }

        @JsonSetter(value="end_user_organization_name", nulls=Nulls.SKIP)
        public Builder endUserOrganizationName(Optional<String> endUserOrganizationName) {
            this.endUserOrganizationName = endUserOrganizationName;
            return this;
        }

        public Builder endUserOrganizationName(String endUserOrganizationName) {
            this.endUserOrganizationName = Optional.of(endUserOrganizationName);
            return this;
        }

        @JsonSetter(value="first_incident_time_after", nulls=Nulls.SKIP)
        public Builder firstIncidentTimeAfter(Optional<OffsetDateTime> firstIncidentTimeAfter) {
            this.firstIncidentTimeAfter = firstIncidentTimeAfter;
            return this;
        }

        public Builder firstIncidentTimeAfter(OffsetDateTime firstIncidentTimeAfter) {
            this.firstIncidentTimeAfter = Optional.of(firstIncidentTimeAfter);
            return this;
        }

        @JsonSetter(value="first_incident_time_before", nulls=Nulls.SKIP)
        public Builder firstIncidentTimeBefore(Optional<OffsetDateTime> firstIncidentTimeBefore) {
            this.firstIncidentTimeBefore = firstIncidentTimeBefore;
            return this;
        }

        public Builder firstIncidentTimeBefore(OffsetDateTime firstIncidentTimeBefore) {
            this.firstIncidentTimeBefore = Optional.of(firstIncidentTimeBefore);
            return this;
        }

        @JsonSetter(value="include_muted", nulls=Nulls.SKIP)
        public Builder includeMuted(Optional<String> includeMuted) {
            this.includeMuted = includeMuted;
            return this;
        }

        public Builder includeMuted(String includeMuted) {
            this.includeMuted = Optional.of(includeMuted);
            return this;
        }

        @JsonSetter(value="integration_name", nulls=Nulls.SKIP)
        public Builder integrationName(Optional<String> integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public Builder integrationName(String integrationName) {
            this.integrationName = Optional.of(integrationName);
            return this;
        }

        @JsonSetter(value="last_incident_time_after", nulls=Nulls.SKIP)
        public Builder lastIncidentTimeAfter(Optional<OffsetDateTime> lastIncidentTimeAfter) {
            this.lastIncidentTimeAfter = lastIncidentTimeAfter;
            return this;
        }

        public Builder lastIncidentTimeAfter(OffsetDateTime lastIncidentTimeAfter) {
            this.lastIncidentTimeAfter = Optional.of(lastIncidentTimeAfter);
            return this;
        }

        @JsonSetter(value="last_incident_time_before", nulls=Nulls.SKIP)
        public Builder lastIncidentTimeBefore(Optional<OffsetDateTime> lastIncidentTimeBefore) {
            this.lastIncidentTimeBefore = lastIncidentTimeBefore;
            return this;
        }

        public Builder lastIncidentTimeBefore(OffsetDateTime lastIncidentTimeBefore) {
            this.lastIncidentTimeBefore = Optional.of(lastIncidentTimeBefore);
            return this;
        }

        @JsonSetter(value="linked_account_id", nulls=Nulls.SKIP)
        public Builder linkedAccountId(Optional<String> linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        public Builder linkedAccountId(String linkedAccountId) {
            this.linkedAccountId = Optional.of(linkedAccountId);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public Builder startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = Optional.of(startDate);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<IssuesListRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(IssuesListRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        public IssuesListRequest build() {
            return new IssuesListRequest(this.accountToken, this.cursor, this.endDate, this.endUserOrganizationName, this.firstIncidentTimeAfter, this.firstIncidentTimeBefore, this.includeMuted, this.integrationName, this.lastIncidentTimeAfter, this.lastIncidentTimeBefore, this.linkedAccountId, this.pageSize, this.startDate, this.status, this.additionalProperties);
        }
    }
}

