/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.purchaseorders;

import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.accounting.purchaseorders.requests.PurchaseOrderEndpointRequest;
import com.merge.api.resources.accounting.purchaseorders.requests.PurchaseOrdersLineItemsRemoteFieldClassesListRequest;
import com.merge.api.resources.accounting.purchaseorders.requests.PurchaseOrdersListRequest;
import com.merge.api.resources.accounting.purchaseorders.requests.PurchaseOrdersRemoteFieldClassesListRequest;
import com.merge.api.resources.accounting.purchaseorders.requests.PurchaseOrdersRetrieveRequest;
import com.merge.api.resources.accounting.types.MetaResponse;
import com.merge.api.resources.accounting.types.PaginatedPurchaseOrderList;
import com.merge.api.resources.accounting.types.PaginatedRemoteFieldClassList;
import com.merge.api.resources.accounting.types.PurchaseOrder;
import com.merge.api.resources.accounting.types.PurchaseOrderRequest;
import com.merge.api.resources.accounting.types.PurchaseOrderResponse;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class PurchaseOrdersClient {
    protected final ClientOptions clientOptions;

    public PurchaseOrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public PaginatedPurchaseOrderList list() {
        return this.list(PurchaseOrdersListRequest.builder().build());
    }

    public PaginatedPurchaseOrderList list(PurchaseOrdersListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedPurchaseOrderList list(PurchaseOrdersListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders");
        if (request.getCompanyId().isPresent()) {
            httpUrl.addQueryParameter("company_id", request.getCompanyId().get());
        }
        if (request.getCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("created_after", request.getCreatedAfter().get().toString());
        }
        if (request.getCreatedBefore().isPresent()) {
            httpUrl.addQueryParameter("created_before", request.getCreatedBefore().get().toString());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("include_remote_fields", request.getIncludeRemoteFields().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getIssueDateAfter().isPresent()) {
            httpUrl.addQueryParameter("issue_date_after", request.getIssueDateAfter().get().toString());
        }
        if (request.getIssueDateBefore().isPresent()) {
            httpUrl.addQueryParameter("issue_date_before", request.getIssueDateBefore().get().toString());
        }
        if (request.getModifiedAfter().isPresent()) {
            httpUrl.addQueryParameter("modified_after", request.getModifiedAfter().get().toString());
        }
        if (request.getModifiedBefore().isPresent()) {
            httpUrl.addQueryParameter("modified_before", request.getModifiedBefore().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("remote_fields", request.getRemoteFields().get());
        }
        if (request.getRemoteId().isPresent()) {
            httpUrl.addQueryParameter("remote_id", request.getRemoteId().get());
        }
        if (request.getShowEnumOrigins().isPresent()) {
            httpUrl.addQueryParameter("show_enum_origins", request.getShowEnumOrigins().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedPurchaseOrderList paginatedPurchaseOrderList = (PaginatedPurchaseOrderList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedPurchaseOrderList.class);
                return paginatedPurchaseOrderList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public PurchaseOrderResponse create(PurchaseOrderEndpointRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PurchaseOrderResponse create(PurchaseOrderEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, PurchaseOrderRequest> properties = new HashMap<String, PurchaseOrderRequest>();
        properties.put("model", request.getModel());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PurchaseOrderResponse purchaseOrderResponse = (PurchaseOrderResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PurchaseOrderResponse.class);
                return purchaseOrderResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public PurchaseOrder retrieve(String id) {
        return this.retrieve(id, PurchaseOrdersRetrieveRequest.builder().build());
    }

    public PurchaseOrder retrieve(String id, PurchaseOrdersRetrieveRequest request) {
        return this.retrieve(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PurchaseOrder retrieve(String id, PurchaseOrdersRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders").addPathSegment(id);
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("include_remote_fields", request.getIncludeRemoteFields().get().toString());
        }
        if (request.getRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("remote_fields", request.getRemoteFields().get());
        }
        if (request.getShowEnumOrigins().isPresent()) {
            httpUrl.addQueryParameter("show_enum_origins", request.getShowEnumOrigins().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PurchaseOrder purchaseOrder = (PurchaseOrder)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PurchaseOrder.class);
                return purchaseOrder;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public PaginatedRemoteFieldClassList lineItemsRemoteFieldClassesList() {
        return this.lineItemsRemoteFieldClassesList(PurchaseOrdersLineItemsRemoteFieldClassesListRequest.builder().build());
    }

    public PaginatedRemoteFieldClassList lineItemsRemoteFieldClassesList(PurchaseOrdersLineItemsRemoteFieldClassesListRequest request) {
        return this.lineItemsRemoteFieldClassesList(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedRemoteFieldClassList lineItemsRemoteFieldClassesList(PurchaseOrdersLineItemsRemoteFieldClassesListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders/line-items/remote-field-classes");
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getIsCommonModelField().isPresent()) {
            httpUrl.addQueryParameter("is_common_model_field", request.getIsCommonModelField().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedRemoteFieldClassList paginatedRemoteFieldClassList = (PaginatedRemoteFieldClassList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedRemoteFieldClassList.class);
                return paginatedRemoteFieldClassList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse metaPostRetrieve() {
        return this.metaPostRetrieve(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse metaPostRetrieve(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders/meta/post").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public PaginatedRemoteFieldClassList remoteFieldClassesList() {
        return this.remoteFieldClassesList(PurchaseOrdersRemoteFieldClassesListRequest.builder().build());
    }

    public PaginatedRemoteFieldClassList remoteFieldClassesList(PurchaseOrdersRemoteFieldClassesListRequest request) {
        return this.remoteFieldClassesList(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedRemoteFieldClassList remoteFieldClassesList(PurchaseOrdersRemoteFieldClassesListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("accounting/v1/purchase-orders/remote-field-classes");
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getIsCommonModelField().isPresent()) {
            httpUrl.addQueryParameter("is_common_model_field", request.getIsCommonModelField().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedRemoteFieldClassList paginatedRemoteFieldClassList = (PaginatedRemoteFieldClassList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedRemoteFieldClassList.class);
                return paginatedRemoteFieldClassList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

