/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AccountClassification;
import com.merge.api.resources.accounting.types.AccountCurrency;
import com.merge.api.resources.accounting.types.AccountStatus;
import com.merge.api.resources.accounting.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Account {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<AccountClassification> classification;
    private final Optional<String> type;
    private final Optional<AccountStatus> status;
    private final Optional<Double> currentBalance;
    private final Optional<AccountCurrency> currency;
    private final Optional<String> accountNumber;
    private final Optional<String> parentAccount;
    private final Optional<String> company;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Account(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> description, Optional<AccountClassification> classification, Optional<String> type, Optional<AccountStatus> status, Optional<Double> currentBalance, Optional<AccountCurrency> currency, Optional<String> accountNumber, Optional<String> parentAccount, Optional<String> company, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.description = description;
        this.classification = classification;
        this.type = type;
        this.status = status;
        this.currentBalance = currentBalance;
        this.currency = currency;
        this.accountNumber = accountNumber;
        this.parentAccount = parentAccount;
        this.company = company;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="classification")
    public Optional<AccountClassification> getClassification() {
        return this.classification;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="status")
    public Optional<AccountStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="current_balance")
    public Optional<Double> getCurrentBalance() {
        return this.currentBalance;
    }

    @JsonProperty(value="currency")
    public Optional<AccountCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="account_number")
    public Optional<String> getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="parent_account")
    public Optional<String> getParentAccount() {
        return this.parentAccount;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Account && this.equalTo((Account)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Account other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.description.equals(other.description) && this.classification.equals(other.classification) && this.type.equals(other.type) && this.status.equals(other.status) && this.currentBalance.equals(other.currentBalance) && this.currency.equals(other.currency) && this.accountNumber.equals(other.accountNumber) && this.parentAccount.equals(other.parentAccount) && this.company.equals(other.company) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.classification, this.type, this.status, this.currentBalance, this.currency, this.accountNumber, this.parentAccount, this.company, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<AccountClassification> classification = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<AccountStatus> status = Optional.empty();
        private Optional<Double> currentBalance = Optional.empty();
        private Optional<AccountCurrency> currency = Optional.empty();
        private Optional<String> accountNumber = Optional.empty();
        private Optional<String> parentAccount = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Account other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.description(other.getDescription());
            this.classification(other.getClassification());
            this.type(other.getType());
            this.status(other.getStatus());
            this.currentBalance(other.getCurrentBalance());
            this.currency(other.getCurrency());
            this.accountNumber(other.getAccountNumber());
            this.parentAccount(other.getParentAccount());
            this.company(other.getCompany());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="classification", nulls=Nulls.SKIP)
        public Builder classification(Optional<AccountClassification> classification) {
            this.classification = classification;
            return this;
        }

        public Builder classification(AccountClassification classification) {
            this.classification = Optional.of(classification);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<AccountStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(AccountStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="current_balance", nulls=Nulls.SKIP)
        public Builder currentBalance(Optional<Double> currentBalance) {
            this.currentBalance = currentBalance;
            return this;
        }

        public Builder currentBalance(Double currentBalance) {
            this.currentBalance = Optional.of(currentBalance);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<AccountCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(AccountCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="account_number", nulls=Nulls.SKIP)
        public Builder accountNumber(Optional<String> accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = Optional.of(accountNumber);
            return this;
        }

        @JsonSetter(value="parent_account", nulls=Nulls.SKIP)
        public Builder parentAccount(Optional<String> parentAccount) {
            this.parentAccount = parentAccount;
            return this;
        }

        public Builder parentAccount(String parentAccount) {
            this.parentAccount = Optional.of(parentAccount);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Account build() {
            return new Account(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.classification, this.type, this.status, this.currentBalance, this.currency, this.accountNumber, this.parentAccount, this.company, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

