/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AccountRequestClassification;
import com.merge.api.resources.accounting.types.AccountRequestCurrency;
import com.merge.api.resources.accounting.types.AccountRequestStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountRequest {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<AccountRequestClassification> classification;
    private final Optional<String> type;
    private final Optional<AccountRequestStatus> status;
    private final Optional<Double> currentBalance;
    private final Optional<AccountRequestCurrency> currency;
    private final Optional<String> accountNumber;
    private final Optional<String> parentAccount;
    private final Optional<String> company;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private AccountRequest(Optional<String> name, Optional<String> description, Optional<AccountRequestClassification> classification, Optional<String> type, Optional<AccountRequestStatus> status, Optional<Double> currentBalance, Optional<AccountRequestCurrency> currency, Optional<String> accountNumber, Optional<String> parentAccount, Optional<String> company, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.classification = classification;
        this.type = type;
        this.status = status;
        this.currentBalance = currentBalance;
        this.currency = currency;
        this.accountNumber = accountNumber;
        this.parentAccount = parentAccount;
        this.company = company;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="classification")
    public Optional<AccountRequestClassification> getClassification() {
        return this.classification;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="status")
    public Optional<AccountRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="current_balance")
    public Optional<Double> getCurrentBalance() {
        return this.currentBalance;
    }

    @JsonProperty(value="currency")
    public Optional<AccountRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="account_number")
    public Optional<String> getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="parent_account")
    public Optional<String> getParentAccount() {
        return this.parentAccount;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountRequest && this.equalTo((AccountRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountRequest other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.classification.equals(other.classification) && this.type.equals(other.type) && this.status.equals(other.status) && this.currentBalance.equals(other.currentBalance) && this.currency.equals(other.currency) && this.accountNumber.equals(other.accountNumber) && this.parentAccount.equals(other.parentAccount) && this.company.equals(other.company) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.classification, this.type, this.status, this.currentBalance, this.currency, this.accountNumber, this.parentAccount, this.company, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<AccountRequestClassification> classification = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<AccountRequestStatus> status = Optional.empty();
        private Optional<Double> currentBalance = Optional.empty();
        private Optional<AccountRequestCurrency> currency = Optional.empty();
        private Optional<String> accountNumber = Optional.empty();
        private Optional<String> parentAccount = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AccountRequest other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.classification(other.getClassification());
            this.type(other.getType());
            this.status(other.getStatus());
            this.currentBalance(other.getCurrentBalance());
            this.currency(other.getCurrency());
            this.accountNumber(other.getAccountNumber());
            this.parentAccount(other.getParentAccount());
            this.company(other.getCompany());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="classification", nulls=Nulls.SKIP)
        public Builder classification(Optional<AccountRequestClassification> classification) {
            this.classification = classification;
            return this;
        }

        public Builder classification(AccountRequestClassification classification) {
            this.classification = Optional.of(classification);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<AccountRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(AccountRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="current_balance", nulls=Nulls.SKIP)
        public Builder currentBalance(Optional<Double> currentBalance) {
            this.currentBalance = currentBalance;
            return this;
        }

        public Builder currentBalance(Double currentBalance) {
            this.currentBalance = Optional.of(currentBalance);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<AccountRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(AccountRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="account_number", nulls=Nulls.SKIP)
        public Builder accountNumber(Optional<String> accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = Optional.of(accountNumber);
            return this;
        }

        @JsonSetter(value="parent_account", nulls=Nulls.SKIP)
        public Builder parentAccount(Optional<String> parentAccount) {
            this.parentAccount = parentAccount;
            return this;
        }

        public Builder parentAccount(String parentAccount) {
            this.parentAccount = Optional.of(parentAccount);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public AccountRequest build() {
            return new AccountRequest(this.name, this.description, this.classification, this.type, this.status, this.currentBalance, this.currency, this.accountNumber, this.parentAccount, this.company, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

