/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountingPhoneNumberRequest {
    private final Optional<String> number;
    private final Optional<String> type;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private AccountingPhoneNumberRequest(Optional<String> number, Optional<String> type, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.number = number;
        this.type = type;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountingPhoneNumberRequest && this.equalTo((AccountingPhoneNumberRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountingPhoneNumberRequest other) {
        return this.number.equals(other.number) && this.type.equals(other.type) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.type, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> number = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AccountingPhoneNumberRequest other) {
            this.number(other.getNumber());
            this.type(other.getType());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public AccountingPhoneNumberRequest build() {
            return new AccountingPhoneNumberRequest(this.number, this.type, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

