/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AddressCountry;
import com.merge.api.resources.accounting.types.AddressType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Address {
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<AddressType> type;
    private final Optional<String> street1;
    private final Optional<String> street2;
    private final Optional<String> city;
    private final Optional<JsonNode> state;
    private final Optional<String> countrySubdivision;
    private final Optional<AddressCountry> country;
    private final Optional<String> zipCode;
    private final Map<String, Object> additionalProperties;

    private Address(Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<AddressType> type, Optional<String> street1, Optional<String> street2, Optional<String> city, Optional<JsonNode> state, Optional<String> countrySubdivision, Optional<AddressCountry> country, Optional<String> zipCode, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.type = type;
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.countrySubdivision = countrySubdivision;
        this.country = country;
        this.zipCode = zipCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="type")
    public Optional<AddressType> getType() {
        return this.type;
    }

    @JsonProperty(value="street_1")
    public Optional<String> getStreet1() {
        return this.street1;
    }

    @JsonProperty(value="street_2")
    public Optional<String> getStreet2() {
        return this.street2;
    }

    @JsonProperty(value="city")
    public Optional<String> getCity() {
        return this.city;
    }

    @JsonProperty(value="state")
    public Optional<JsonNode> getState() {
        return this.state;
    }

    @JsonProperty(value="country_subdivision")
    public Optional<String> getCountrySubdivision() {
        return this.countrySubdivision;
    }

    @JsonProperty(value="country")
    public Optional<AddressCountry> getCountry() {
        return this.country;
    }

    @JsonProperty(value="zip_code")
    public Optional<String> getZipCode() {
        return this.zipCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Address && this.equalTo((Address)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Address other) {
        return this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.type.equals(other.type) && this.street1.equals(other.street1) && this.street2.equals(other.street2) && this.city.equals(other.city) && this.state.equals(other.state) && this.countrySubdivision.equals(other.countrySubdivision) && this.country.equals(other.country) && this.zipCode.equals(other.zipCode);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.type, this.street1, this.street2, this.city, this.state, this.countrySubdivision, this.country, this.zipCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<AddressType> type = Optional.empty();
        private Optional<String> street1 = Optional.empty();
        private Optional<String> street2 = Optional.empty();
        private Optional<String> city = Optional.empty();
        private Optional<JsonNode> state = Optional.empty();
        private Optional<String> countrySubdivision = Optional.empty();
        private Optional<AddressCountry> country = Optional.empty();
        private Optional<String> zipCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Address other) {
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.type(other.getType());
            this.street1(other.getStreet1());
            this.street2(other.getStreet2());
            this.city(other.getCity());
            this.state(other.getState());
            this.countrySubdivision(other.getCountrySubdivision());
            this.country(other.getCountry());
            this.zipCode(other.getZipCode());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<AddressType> type) {
            this.type = type;
            return this;
        }

        public Builder type(AddressType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="street_1", nulls=Nulls.SKIP)
        public Builder street1(Optional<String> street1) {
            this.street1 = street1;
            return this;
        }

        public Builder street1(String street1) {
            this.street1 = Optional.of(street1);
            return this;
        }

        @JsonSetter(value="street_2", nulls=Nulls.SKIP)
        public Builder street2(Optional<String> street2) {
            this.street2 = street2;
            return this;
        }

        public Builder street2(String street2) {
            this.street2 = Optional.of(street2);
            return this;
        }

        @JsonSetter(value="city", nulls=Nulls.SKIP)
        public Builder city(Optional<String> city) {
            this.city = city;
            return this;
        }

        public Builder city(String city) {
            this.city = Optional.of(city);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<JsonNode> state) {
            this.state = state;
            return this;
        }

        public Builder state(JsonNode state) {
            this.state = Optional.of(state);
            return this;
        }

        @JsonSetter(value="country_subdivision", nulls=Nulls.SKIP)
        public Builder countrySubdivision(Optional<String> countrySubdivision) {
            this.countrySubdivision = countrySubdivision;
            return this;
        }

        public Builder countrySubdivision(String countrySubdivision) {
            this.countrySubdivision = Optional.of(countrySubdivision);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<AddressCountry> country) {
            this.country = country;
            return this;
        }

        public Builder country(AddressCountry country) {
            this.country = Optional.of(country);
            return this;
        }

        @JsonSetter(value="zip_code", nulls=Nulls.SKIP)
        public Builder zipCode(Optional<String> zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder zipCode(String zipCode) {
            this.zipCode = Optional.of(zipCode);
            return this;
        }

        public Address build() {
            return new Address(this.createdAt, this.modifiedAt, this.type, this.street1, this.street2, this.city, this.state, this.countrySubdivision, this.country, this.zipCode, this.additionalProperties);
        }
    }
}

