/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AddressRequestCountry;
import com.merge.api.resources.accounting.types.AddressRequestType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AddressRequest {
    private final Optional<AddressRequestType> type;
    private final Optional<String> street1;
    private final Optional<String> street2;
    private final Optional<String> city;
    private final Optional<String> countrySubdivision;
    private final Optional<AddressRequestCountry> country;
    private final Optional<String> zipCode;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private AddressRequest(Optional<AddressRequestType> type, Optional<String> street1, Optional<String> street2, Optional<String> city, Optional<String> countrySubdivision, Optional<AddressRequestCountry> country, Optional<String> zipCode, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.type = type;
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.countrySubdivision = countrySubdivision;
        this.country = country;
        this.zipCode = zipCode;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<AddressRequestType> getType() {
        return this.type;
    }

    @JsonProperty(value="street_1")
    public Optional<String> getStreet1() {
        return this.street1;
    }

    @JsonProperty(value="street_2")
    public Optional<String> getStreet2() {
        return this.street2;
    }

    @JsonProperty(value="city")
    public Optional<String> getCity() {
        return this.city;
    }

    @JsonProperty(value="country_subdivision")
    public Optional<String> getCountrySubdivision() {
        return this.countrySubdivision;
    }

    @JsonProperty(value="country")
    public Optional<AddressRequestCountry> getCountry() {
        return this.country;
    }

    @JsonProperty(value="zip_code")
    public Optional<String> getZipCode() {
        return this.zipCode;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AddressRequest && this.equalTo((AddressRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddressRequest other) {
        return this.type.equals(other.type) && this.street1.equals(other.street1) && this.street2.equals(other.street2) && this.city.equals(other.city) && this.countrySubdivision.equals(other.countrySubdivision) && this.country.equals(other.country) && this.zipCode.equals(other.zipCode) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.street1, this.street2, this.city, this.countrySubdivision, this.country, this.zipCode, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<AddressRequestType> type = Optional.empty();
        private Optional<String> street1 = Optional.empty();
        private Optional<String> street2 = Optional.empty();
        private Optional<String> city = Optional.empty();
        private Optional<String> countrySubdivision = Optional.empty();
        private Optional<AddressRequestCountry> country = Optional.empty();
        private Optional<String> zipCode = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AddressRequest other) {
            this.type(other.getType());
            this.street1(other.getStreet1());
            this.street2(other.getStreet2());
            this.city(other.getCity());
            this.countrySubdivision(other.getCountrySubdivision());
            this.country(other.getCountry());
            this.zipCode(other.getZipCode());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<AddressRequestType> type) {
            this.type = type;
            return this;
        }

        public Builder type(AddressRequestType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="street_1", nulls=Nulls.SKIP)
        public Builder street1(Optional<String> street1) {
            this.street1 = street1;
            return this;
        }

        public Builder street1(String street1) {
            this.street1 = Optional.of(street1);
            return this;
        }

        @JsonSetter(value="street_2", nulls=Nulls.SKIP)
        public Builder street2(Optional<String> street2) {
            this.street2 = street2;
            return this;
        }

        public Builder street2(String street2) {
            this.street2 = Optional.of(street2);
            return this;
        }

        @JsonSetter(value="city", nulls=Nulls.SKIP)
        public Builder city(Optional<String> city) {
            this.city = city;
            return this;
        }

        public Builder city(String city) {
            this.city = Optional.of(city);
            return this;
        }

        @JsonSetter(value="country_subdivision", nulls=Nulls.SKIP)
        public Builder countrySubdivision(Optional<String> countrySubdivision) {
            this.countrySubdivision = countrySubdivision;
            return this;
        }

        public Builder countrySubdivision(String countrySubdivision) {
            this.countrySubdivision = Optional.of(countrySubdivision);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<AddressRequestCountry> country) {
            this.country = country;
            return this;
        }

        public Builder country(AddressRequestCountry country) {
            this.country = Optional.of(country);
            return this;
        }

        @JsonSetter(value="zip_code", nulls=Nulls.SKIP)
        public Builder zipCode(Optional<String> zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder zipCode(String zipCode) {
            this.zipCode = Optional.of(zipCode);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public AddressRequest build() {
            return new AddressRequest(this.type, this.street1, this.street2, this.city, this.countrySubdivision, this.country, this.zipCode, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

