/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.BalanceSheetCompany;
import com.merge.api.resources.accounting.types.BalanceSheetCurrency;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.ReportItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class BalanceSheet {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<BalanceSheetCurrency> currency;
    private final Optional<BalanceSheetCompany> company;
    private final Optional<OffsetDateTime> date;
    private final Optional<Double> netAssets;
    private final Optional<List<ReportItem>> assets;
    private final Optional<List<ReportItem>> liabilities;
    private final Optional<List<ReportItem>> equity;
    private final Optional<OffsetDateTime> remoteGeneratedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private BalanceSheet(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<BalanceSheetCurrency> currency, Optional<BalanceSheetCompany> company, Optional<OffsetDateTime> date, Optional<Double> netAssets, Optional<List<ReportItem>> assets, Optional<List<ReportItem>> liabilities, Optional<List<ReportItem>> equity, Optional<OffsetDateTime> remoteGeneratedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.currency = currency;
        this.company = company;
        this.date = date;
        this.netAssets = netAssets;
        this.assets = assets;
        this.liabilities = liabilities;
        this.equity = equity;
        this.remoteGeneratedAt = remoteGeneratedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="currency")
    public Optional<BalanceSheetCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="company")
    public Optional<BalanceSheetCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="date")
    public Optional<OffsetDateTime> getDate() {
        return this.date;
    }

    @JsonProperty(value="net_assets")
    public Optional<Double> getNetAssets() {
        return this.netAssets;
    }

    @JsonProperty(value="assets")
    public Optional<List<ReportItem>> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="liabilities")
    public Optional<List<ReportItem>> getLiabilities() {
        return this.liabilities;
    }

    @JsonProperty(value="equity")
    public Optional<List<ReportItem>> getEquity() {
        return this.equity;
    }

    @JsonProperty(value="remote_generated_at")
    public Optional<OffsetDateTime> getRemoteGeneratedAt() {
        return this.remoteGeneratedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BalanceSheet && this.equalTo((BalanceSheet)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BalanceSheet other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.currency.equals(other.currency) && this.company.equals(other.company) && this.date.equals(other.date) && this.netAssets.equals(other.netAssets) && this.assets.equals(other.assets) && this.liabilities.equals(other.liabilities) && this.equity.equals(other.equity) && this.remoteGeneratedAt.equals(other.remoteGeneratedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.date, this.netAssets, this.assets, this.liabilities, this.equity, this.remoteGeneratedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<BalanceSheetCurrency> currency = Optional.empty();
        private Optional<BalanceSheetCompany> company = Optional.empty();
        private Optional<OffsetDateTime> date = Optional.empty();
        private Optional<Double> netAssets = Optional.empty();
        private Optional<List<ReportItem>> assets = Optional.empty();
        private Optional<List<ReportItem>> liabilities = Optional.empty();
        private Optional<List<ReportItem>> equity = Optional.empty();
        private Optional<OffsetDateTime> remoteGeneratedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BalanceSheet other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.currency(other.getCurrency());
            this.company(other.getCompany());
            this.date(other.getDate());
            this.netAssets(other.getNetAssets());
            this.assets(other.getAssets());
            this.liabilities(other.getLiabilities());
            this.equity(other.getEquity());
            this.remoteGeneratedAt(other.getRemoteGeneratedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<BalanceSheetCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(BalanceSheetCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<BalanceSheetCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(BalanceSheetCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="date", nulls=Nulls.SKIP)
        public Builder date(Optional<OffsetDateTime> date) {
            this.date = date;
            return this;
        }

        public Builder date(OffsetDateTime date) {
            this.date = Optional.of(date);
            return this;
        }

        @JsonSetter(value="net_assets", nulls=Nulls.SKIP)
        public Builder netAssets(Optional<Double> netAssets) {
            this.netAssets = netAssets;
            return this;
        }

        public Builder netAssets(Double netAssets) {
            this.netAssets = Optional.of(netAssets);
            return this;
        }

        @JsonSetter(value="assets", nulls=Nulls.SKIP)
        public Builder assets(Optional<List<ReportItem>> assets) {
            this.assets = assets;
            return this;
        }

        public Builder assets(List<ReportItem> assets) {
            this.assets = Optional.of(assets);
            return this;
        }

        @JsonSetter(value="liabilities", nulls=Nulls.SKIP)
        public Builder liabilities(Optional<List<ReportItem>> liabilities) {
            this.liabilities = liabilities;
            return this;
        }

        public Builder liabilities(List<ReportItem> liabilities) {
            this.liabilities = Optional.of(liabilities);
            return this;
        }

        @JsonSetter(value="equity", nulls=Nulls.SKIP)
        public Builder equity(Optional<List<ReportItem>> equity) {
            this.equity = equity;
            return this;
        }

        public Builder equity(List<ReportItem> equity) {
            this.equity = Optional.of(equity);
            return this;
        }

        @JsonSetter(value="remote_generated_at", nulls=Nulls.SKIP)
        public Builder remoteGeneratedAt(Optional<OffsetDateTime> remoteGeneratedAt) {
            this.remoteGeneratedAt = remoteGeneratedAt;
            return this;
        }

        public Builder remoteGeneratedAt(OffsetDateTime remoteGeneratedAt) {
            this.remoteGeneratedAt = Optional.of(remoteGeneratedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public BalanceSheet build() {
            return new BalanceSheet(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.date, this.netAssets, this.assets, this.liabilities, this.equity, this.remoteGeneratedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

