/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.CashFlowStatementCompany;
import com.merge.api.resources.accounting.types.CashFlowStatementCurrency;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.ReportItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CashFlowStatement {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<CashFlowStatementCurrency> currency;
    private final Optional<CashFlowStatementCompany> company;
    private final Optional<OffsetDateTime> startPeriod;
    private final Optional<OffsetDateTime> endPeriod;
    private final Optional<Double> cashAtBeginningOfPeriod;
    private final Optional<Double> cashAtEndOfPeriod;
    private final Optional<List<ReportItem>> operatingActivities;
    private final Optional<List<ReportItem>> investingActivities;
    private final Optional<List<ReportItem>> financingActivities;
    private final Optional<OffsetDateTime> remoteGeneratedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private CashFlowStatement(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<CashFlowStatementCurrency> currency, Optional<CashFlowStatementCompany> company, Optional<OffsetDateTime> startPeriod, Optional<OffsetDateTime> endPeriod, Optional<Double> cashAtBeginningOfPeriod, Optional<Double> cashAtEndOfPeriod, Optional<List<ReportItem>> operatingActivities, Optional<List<ReportItem>> investingActivities, Optional<List<ReportItem>> financingActivities, Optional<OffsetDateTime> remoteGeneratedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.currency = currency;
        this.company = company;
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
        this.cashAtBeginningOfPeriod = cashAtBeginningOfPeriod;
        this.cashAtEndOfPeriod = cashAtEndOfPeriod;
        this.operatingActivities = operatingActivities;
        this.investingActivities = investingActivities;
        this.financingActivities = financingActivities;
        this.remoteGeneratedAt = remoteGeneratedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="currency")
    public Optional<CashFlowStatementCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="company")
    public Optional<CashFlowStatementCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="start_period")
    public Optional<OffsetDateTime> getStartPeriod() {
        return this.startPeriod;
    }

    @JsonProperty(value="end_period")
    public Optional<OffsetDateTime> getEndPeriod() {
        return this.endPeriod;
    }

    @JsonProperty(value="cash_at_beginning_of_period")
    public Optional<Double> getCashAtBeginningOfPeriod() {
        return this.cashAtBeginningOfPeriod;
    }

    @JsonProperty(value="cash_at_end_of_period")
    public Optional<Double> getCashAtEndOfPeriod() {
        return this.cashAtEndOfPeriod;
    }

    @JsonProperty(value="operating_activities")
    public Optional<List<ReportItem>> getOperatingActivities() {
        return this.operatingActivities;
    }

    @JsonProperty(value="investing_activities")
    public Optional<List<ReportItem>> getInvestingActivities() {
        return this.investingActivities;
    }

    @JsonProperty(value="financing_activities")
    public Optional<List<ReportItem>> getFinancingActivities() {
        return this.financingActivities;
    }

    @JsonProperty(value="remote_generated_at")
    public Optional<OffsetDateTime> getRemoteGeneratedAt() {
        return this.remoteGeneratedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashFlowStatement && this.equalTo((CashFlowStatement)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashFlowStatement other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.currency.equals(other.currency) && this.company.equals(other.company) && this.startPeriod.equals(other.startPeriod) && this.endPeriod.equals(other.endPeriod) && this.cashAtBeginningOfPeriod.equals(other.cashAtBeginningOfPeriod) && this.cashAtEndOfPeriod.equals(other.cashAtEndOfPeriod) && this.operatingActivities.equals(other.operatingActivities) && this.investingActivities.equals(other.investingActivities) && this.financingActivities.equals(other.financingActivities) && this.remoteGeneratedAt.equals(other.remoteGeneratedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.startPeriod, this.endPeriod, this.cashAtBeginningOfPeriod, this.cashAtEndOfPeriod, this.operatingActivities, this.investingActivities, this.financingActivities, this.remoteGeneratedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<CashFlowStatementCurrency> currency = Optional.empty();
        private Optional<CashFlowStatementCompany> company = Optional.empty();
        private Optional<OffsetDateTime> startPeriod = Optional.empty();
        private Optional<OffsetDateTime> endPeriod = Optional.empty();
        private Optional<Double> cashAtBeginningOfPeriod = Optional.empty();
        private Optional<Double> cashAtEndOfPeriod = Optional.empty();
        private Optional<List<ReportItem>> operatingActivities = Optional.empty();
        private Optional<List<ReportItem>> investingActivities = Optional.empty();
        private Optional<List<ReportItem>> financingActivities = Optional.empty();
        private Optional<OffsetDateTime> remoteGeneratedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CashFlowStatement other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.currency(other.getCurrency());
            this.company(other.getCompany());
            this.startPeriod(other.getStartPeriod());
            this.endPeriod(other.getEndPeriod());
            this.cashAtBeginningOfPeriod(other.getCashAtBeginningOfPeriod());
            this.cashAtEndOfPeriod(other.getCashAtEndOfPeriod());
            this.operatingActivities(other.getOperatingActivities());
            this.investingActivities(other.getInvestingActivities());
            this.financingActivities(other.getFinancingActivities());
            this.remoteGeneratedAt(other.getRemoteGeneratedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<CashFlowStatementCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(CashFlowStatementCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<CashFlowStatementCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(CashFlowStatementCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="start_period", nulls=Nulls.SKIP)
        public Builder startPeriod(Optional<OffsetDateTime> startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        public Builder startPeriod(OffsetDateTime startPeriod) {
            this.startPeriod = Optional.of(startPeriod);
            return this;
        }

        @JsonSetter(value="end_period", nulls=Nulls.SKIP)
        public Builder endPeriod(Optional<OffsetDateTime> endPeriod) {
            this.endPeriod = endPeriod;
            return this;
        }

        public Builder endPeriod(OffsetDateTime endPeriod) {
            this.endPeriod = Optional.of(endPeriod);
            return this;
        }

        @JsonSetter(value="cash_at_beginning_of_period", nulls=Nulls.SKIP)
        public Builder cashAtBeginningOfPeriod(Optional<Double> cashAtBeginningOfPeriod) {
            this.cashAtBeginningOfPeriod = cashAtBeginningOfPeriod;
            return this;
        }

        public Builder cashAtBeginningOfPeriod(Double cashAtBeginningOfPeriod) {
            this.cashAtBeginningOfPeriod = Optional.of(cashAtBeginningOfPeriod);
            return this;
        }

        @JsonSetter(value="cash_at_end_of_period", nulls=Nulls.SKIP)
        public Builder cashAtEndOfPeriod(Optional<Double> cashAtEndOfPeriod) {
            this.cashAtEndOfPeriod = cashAtEndOfPeriod;
            return this;
        }

        public Builder cashAtEndOfPeriod(Double cashAtEndOfPeriod) {
            this.cashAtEndOfPeriod = Optional.of(cashAtEndOfPeriod);
            return this;
        }

        @JsonSetter(value="operating_activities", nulls=Nulls.SKIP)
        public Builder operatingActivities(Optional<List<ReportItem>> operatingActivities) {
            this.operatingActivities = operatingActivities;
            return this;
        }

        public Builder operatingActivities(List<ReportItem> operatingActivities) {
            this.operatingActivities = Optional.of(operatingActivities);
            return this;
        }

        @JsonSetter(value="investing_activities", nulls=Nulls.SKIP)
        public Builder investingActivities(Optional<List<ReportItem>> investingActivities) {
            this.investingActivities = investingActivities;
            return this;
        }

        public Builder investingActivities(List<ReportItem> investingActivities) {
            this.investingActivities = Optional.of(investingActivities);
            return this;
        }

        @JsonSetter(value="financing_activities", nulls=Nulls.SKIP)
        public Builder financingActivities(Optional<List<ReportItem>> financingActivities) {
            this.financingActivities = financingActivities;
            return this;
        }

        public Builder financingActivities(List<ReportItem> financingActivities) {
            this.financingActivities = Optional.of(financingActivities);
            return this;
        }

        @JsonSetter(value="remote_generated_at", nulls=Nulls.SKIP)
        public Builder remoteGeneratedAt(Optional<OffsetDateTime> remoteGeneratedAt) {
            this.remoteGeneratedAt = remoteGeneratedAt;
            return this;
        }

        public Builder remoteGeneratedAt(OffsetDateTime remoteGeneratedAt) {
            this.remoteGeneratedAt = Optional.of(remoteGeneratedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public CashFlowStatement build() {
            return new CashFlowStatement(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.startPeriod, this.endPeriod, this.cashAtBeginningOfPeriod, this.cashAtEndOfPeriod, this.operatingActivities, this.investingActivities, this.financingActivities, this.remoteGeneratedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

