/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.EnabledActionsEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CommonModelScopesBodyRequest {
    private final String modelId;
    private final List<EnabledActionsEnum> enabledActions;
    private final List<String> disabledFields;
    private final Map<String, Object> additionalProperties;

    private CommonModelScopesBodyRequest(String modelId, List<EnabledActionsEnum> enabledActions, List<String> disabledFields, Map<String, Object> additionalProperties) {
        this.modelId = modelId;
        this.enabledActions = enabledActions;
        this.disabledFields = disabledFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model_id")
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="enabled_actions")
    public List<EnabledActionsEnum> getEnabledActions() {
        return this.enabledActions;
    }

    @JsonProperty(value="disabled_fields")
    public List<String> getDisabledFields() {
        return this.disabledFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CommonModelScopesBodyRequest && this.equalTo((CommonModelScopesBodyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CommonModelScopesBodyRequest other) {
        return this.modelId.equals(other.modelId) && this.enabledActions.equals(other.enabledActions) && this.disabledFields.equals(other.disabledFields);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.enabledActions, this.disabledFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelIdStage,
    _FinalStage {
        private String modelId;
        private List<String> disabledFields = new ArrayList<String>();
        private List<EnabledActionsEnum> enabledActions = new ArrayList<EnabledActionsEnum>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CommonModelScopesBodyRequest other) {
            this.modelId(other.getModelId());
            this.enabledActions(other.getEnabledActions());
            this.disabledFields(other.getDisabledFields());
            return this;
        }

        @Override
        @JsonSetter(value="model_id")
        public _FinalStage modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public _FinalStage addAllDisabledFields(List<String> disabledFields) {
            this.disabledFields.addAll(disabledFields);
            return this;
        }

        @Override
        public _FinalStage addDisabledFields(String disabledFields) {
            this.disabledFields.add(disabledFields);
            return this;
        }

        @Override
        @JsonSetter(value="disabled_fields", nulls=Nulls.SKIP)
        public _FinalStage disabledFields(List<String> disabledFields) {
            this.disabledFields.clear();
            this.disabledFields.addAll(disabledFields);
            return this;
        }

        @Override
        public _FinalStage addAllEnabledActions(List<EnabledActionsEnum> enabledActions) {
            this.enabledActions.addAll(enabledActions);
            return this;
        }

        @Override
        public _FinalStage addEnabledActions(EnabledActionsEnum enabledActions) {
            this.enabledActions.add(enabledActions);
            return this;
        }

        @Override
        @JsonSetter(value="enabled_actions", nulls=Nulls.SKIP)
        public _FinalStage enabledActions(List<EnabledActionsEnum> enabledActions) {
            this.enabledActions.clear();
            this.enabledActions.addAll(enabledActions);
            return this;
        }

        @Override
        public CommonModelScopesBodyRequest build() {
            return new CommonModelScopesBodyRequest(this.modelId, this.enabledActions, this.disabledFields, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CommonModelScopesBodyRequest build();

        public _FinalStage enabledActions(List<EnabledActionsEnum> var1);

        public _FinalStage addEnabledActions(EnabledActionsEnum var1);

        public _FinalStage addAllEnabledActions(List<EnabledActionsEnum> var1);

        public _FinalStage disabledFields(List<String> var1);

        public _FinalStage addDisabledFields(String var1);

        public _FinalStage addAllDisabledFields(List<String> var1);
    }

    public static interface ModelIdStage {
        public _FinalStage modelId(String var1);

        public Builder from(CommonModelScopesBodyRequest var1);
    }
}

