/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AccountingPhoneNumber;
import com.merge.api.resources.accounting.types.Address;
import com.merge.api.resources.accounting.types.CompanyInfoCurrency;
import com.merge.api.resources.accounting.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CompanyInfo {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> legalName;
    private final Optional<String> taxNumber;
    private final Optional<Integer> fiscalYearEndMonth;
    private final Optional<Integer> fiscalYearEndDay;
    private final Optional<CompanyInfoCurrency> currency;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<List<Optional<String>>> urls;
    private final Optional<List<Address>> addresses;
    private final Optional<List<AccountingPhoneNumber>> phoneNumbers;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private CompanyInfo(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> legalName, Optional<String> taxNumber, Optional<Integer> fiscalYearEndMonth, Optional<Integer> fiscalYearEndDay, Optional<CompanyInfoCurrency> currency, Optional<OffsetDateTime> remoteCreatedAt, Optional<List<Optional<String>>> urls, Optional<List<Address>> addresses, Optional<List<AccountingPhoneNumber>> phoneNumbers, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.legalName = legalName;
        this.taxNumber = taxNumber;
        this.fiscalYearEndMonth = fiscalYearEndMonth;
        this.fiscalYearEndDay = fiscalYearEndDay;
        this.currency = currency;
        this.remoteCreatedAt = remoteCreatedAt;
        this.urls = urls;
        this.addresses = addresses;
        this.phoneNumbers = phoneNumbers;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="legal_name")
    public Optional<String> getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="tax_number")
    public Optional<String> getTaxNumber() {
        return this.taxNumber;
    }

    @JsonProperty(value="fiscal_year_end_month")
    public Optional<Integer> getFiscalYearEndMonth() {
        return this.fiscalYearEndMonth;
    }

    @JsonProperty(value="fiscal_year_end_day")
    public Optional<Integer> getFiscalYearEndDay() {
        return this.fiscalYearEndDay;
    }

    @JsonProperty(value="currency")
    public Optional<CompanyInfoCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="urls")
    public Optional<List<Optional<String>>> getUrls() {
        return this.urls;
    }

    @JsonProperty(value="addresses")
    public Optional<List<Address>> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<AccountingPhoneNumber>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyInfo && this.equalTo((CompanyInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyInfo other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.legalName.equals(other.legalName) && this.taxNumber.equals(other.taxNumber) && this.fiscalYearEndMonth.equals(other.fiscalYearEndMonth) && this.fiscalYearEndDay.equals(other.fiscalYearEndDay) && this.currency.equals(other.currency) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.urls.equals(other.urls) && this.addresses.equals(other.addresses) && this.phoneNumbers.equals(other.phoneNumbers) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.legalName, this.taxNumber, this.fiscalYearEndMonth, this.fiscalYearEndDay, this.currency, this.remoteCreatedAt, this.urls, this.addresses, this.phoneNumbers, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> legalName = Optional.empty();
        private Optional<String> taxNumber = Optional.empty();
        private Optional<Integer> fiscalYearEndMonth = Optional.empty();
        private Optional<Integer> fiscalYearEndDay = Optional.empty();
        private Optional<CompanyInfoCurrency> currency = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<List<Optional<String>>> urls = Optional.empty();
        private Optional<List<Address>> addresses = Optional.empty();
        private Optional<List<AccountingPhoneNumber>> phoneNumbers = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CompanyInfo other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.legalName(other.getLegalName());
            this.taxNumber(other.getTaxNumber());
            this.fiscalYearEndMonth(other.getFiscalYearEndMonth());
            this.fiscalYearEndDay(other.getFiscalYearEndDay());
            this.currency(other.getCurrency());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.urls(other.getUrls());
            this.addresses(other.getAddresses());
            this.phoneNumbers(other.getPhoneNumbers());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="legal_name", nulls=Nulls.SKIP)
        public Builder legalName(Optional<String> legalName) {
            this.legalName = legalName;
            return this;
        }

        public Builder legalName(String legalName) {
            this.legalName = Optional.of(legalName);
            return this;
        }

        @JsonSetter(value="tax_number", nulls=Nulls.SKIP)
        public Builder taxNumber(Optional<String> taxNumber) {
            this.taxNumber = taxNumber;
            return this;
        }

        public Builder taxNumber(String taxNumber) {
            this.taxNumber = Optional.of(taxNumber);
            return this;
        }

        @JsonSetter(value="fiscal_year_end_month", nulls=Nulls.SKIP)
        public Builder fiscalYearEndMonth(Optional<Integer> fiscalYearEndMonth) {
            this.fiscalYearEndMonth = fiscalYearEndMonth;
            return this;
        }

        public Builder fiscalYearEndMonth(Integer fiscalYearEndMonth) {
            this.fiscalYearEndMonth = Optional.of(fiscalYearEndMonth);
            return this;
        }

        @JsonSetter(value="fiscal_year_end_day", nulls=Nulls.SKIP)
        public Builder fiscalYearEndDay(Optional<Integer> fiscalYearEndDay) {
            this.fiscalYearEndDay = fiscalYearEndDay;
            return this;
        }

        public Builder fiscalYearEndDay(Integer fiscalYearEndDay) {
            this.fiscalYearEndDay = Optional.of(fiscalYearEndDay);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<CompanyInfoCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(CompanyInfoCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="urls", nulls=Nulls.SKIP)
        public Builder urls(Optional<List<Optional<String>>> urls) {
            this.urls = urls;
            return this;
        }

        public Builder urls(List<Optional<String>> urls) {
            this.urls = Optional.of(urls);
            return this;
        }

        @JsonSetter(value="addresses", nulls=Nulls.SKIP)
        public Builder addresses(Optional<List<Address>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            this.addresses = Optional.of(addresses);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<AccountingPhoneNumber>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<AccountingPhoneNumber> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public CompanyInfo build() {
            return new CompanyInfo(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.legalName, this.taxNumber, this.fiscalYearEndMonth, this.fiscalYearEndDay, this.currency, this.remoteCreatedAt, this.urls, this.addresses, this.phoneNumbers, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

