/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.AccountingPhoneNumberRequest;
import com.merge.api.resources.accounting.types.ContactRequestAddressesItem;
import com.merge.api.resources.accounting.types.ContactRequestStatus;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ContactRequest {
    private final Optional<String> name;
    private final Optional<Boolean> isSupplier;
    private final Optional<Boolean> isCustomer;
    private final Optional<String> emailAddress;
    private final Optional<String> taxNumber;
    private final Optional<ContactRequestStatus> status;
    private final Optional<String> currency;
    private final Optional<String> company;
    private final Optional<List<Optional<ContactRequestAddressesItem>>> addresses;
    private final Optional<List<AccountingPhoneNumberRequest>> phoneNumbers;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private ContactRequest(Optional<String> name, Optional<Boolean> isSupplier, Optional<Boolean> isCustomer, Optional<String> emailAddress, Optional<String> taxNumber, Optional<ContactRequestStatus> status, Optional<String> currency, Optional<String> company, Optional<List<Optional<ContactRequestAddressesItem>>> addresses, Optional<List<AccountingPhoneNumberRequest>> phoneNumbers, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.name = name;
        this.isSupplier = isSupplier;
        this.isCustomer = isCustomer;
        this.emailAddress = emailAddress;
        this.taxNumber = taxNumber;
        this.status = status;
        this.currency = currency;
        this.company = company;
        this.addresses = addresses;
        this.phoneNumbers = phoneNumbers;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="is_supplier")
    public Optional<Boolean> getIsSupplier() {
        return this.isSupplier;
    }

    @JsonProperty(value="is_customer")
    public Optional<Boolean> getIsCustomer() {
        return this.isCustomer;
    }

    @JsonProperty(value="email_address")
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="tax_number")
    public Optional<String> getTaxNumber() {
        return this.taxNumber;
    }

    @JsonProperty(value="status")
    public Optional<ContactRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="addresses")
    public Optional<List<Optional<ContactRequestAddressesItem>>> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<AccountingPhoneNumberRequest>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactRequest && this.equalTo((ContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactRequest other) {
        return this.name.equals(other.name) && this.isSupplier.equals(other.isSupplier) && this.isCustomer.equals(other.isCustomer) && this.emailAddress.equals(other.emailAddress) && this.taxNumber.equals(other.taxNumber) && this.status.equals(other.status) && this.currency.equals(other.currency) && this.company.equals(other.company) && this.addresses.equals(other.addresses) && this.phoneNumbers.equals(other.phoneNumbers) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isSupplier, this.isCustomer, this.emailAddress, this.taxNumber, this.status, this.currency, this.company, this.addresses, this.phoneNumbers, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> isSupplier = Optional.empty();
        private Optional<Boolean> isCustomer = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> taxNumber = Optional.empty();
        private Optional<ContactRequestStatus> status = Optional.empty();
        private Optional<String> currency = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<List<Optional<ContactRequestAddressesItem>>> addresses = Optional.empty();
        private Optional<List<AccountingPhoneNumberRequest>> phoneNumbers = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContactRequest other) {
            this.name(other.getName());
            this.isSupplier(other.getIsSupplier());
            this.isCustomer(other.getIsCustomer());
            this.emailAddress(other.getEmailAddress());
            this.taxNumber(other.getTaxNumber());
            this.status(other.getStatus());
            this.currency(other.getCurrency());
            this.company(other.getCompany());
            this.addresses(other.getAddresses());
            this.phoneNumbers(other.getPhoneNumbers());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="is_supplier", nulls=Nulls.SKIP)
        public Builder isSupplier(Optional<Boolean> isSupplier) {
            this.isSupplier = isSupplier;
            return this;
        }

        public Builder isSupplier(Boolean isSupplier) {
            this.isSupplier = Optional.of(isSupplier);
            return this;
        }

        @JsonSetter(value="is_customer", nulls=Nulls.SKIP)
        public Builder isCustomer(Optional<Boolean> isCustomer) {
            this.isCustomer = isCustomer;
            return this;
        }

        public Builder isCustomer(Boolean isCustomer) {
            this.isCustomer = Optional.of(isCustomer);
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.of(emailAddress);
            return this;
        }

        @JsonSetter(value="tax_number", nulls=Nulls.SKIP)
        public Builder taxNumber(Optional<String> taxNumber) {
            this.taxNumber = taxNumber;
            return this;
        }

        public Builder taxNumber(String taxNumber) {
            this.taxNumber = Optional.of(taxNumber);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<ContactRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ContactRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="addresses", nulls=Nulls.SKIP)
        public Builder addresses(Optional<List<Optional<ContactRequestAddressesItem>>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(List<Optional<ContactRequestAddressesItem>> addresses) {
            this.addresses = Optional.of(addresses);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<AccountingPhoneNumberRequest>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<AccountingPhoneNumberRequest> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public ContactRequest build() {
            return new ContactRequest(this.name, this.isSupplier, this.isCustomer, this.emailAddress, this.taxNumber, this.status, this.currency, this.company, this.addresses, this.phoneNumbers, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

