/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.CreditNoteAccountingPeriod;
import com.merge.api.resources.accounting.types.CreditNoteAppliedPaymentsItem;
import com.merge.api.resources.accounting.types.CreditNoteCompany;
import com.merge.api.resources.accounting.types.CreditNoteContact;
import com.merge.api.resources.accounting.types.CreditNoteCurrency;
import com.merge.api.resources.accounting.types.CreditNoteLineItem;
import com.merge.api.resources.accounting.types.CreditNotePaymentsItem;
import com.merge.api.resources.accounting.types.CreditNoteStatus;
import com.merge.api.resources.accounting.types.CreditNoteTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreditNote {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<CreditNoteStatus> status;
    private final Optional<String> number;
    private final Optional<CreditNoteContact> contact;
    private final Optional<CreditNoteCompany> company;
    private final Optional<String> exchangeRate;
    private final Optional<Double> totalAmount;
    private final Optional<Double> remainingCredit;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<List<CreditNoteLineItem>> lineItems;
    private final Optional<List<Optional<CreditNoteTrackingCategoriesItem>>> trackingCategories;
    private final Optional<CreditNoteCurrency> currency;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<List<Optional<CreditNotePaymentsItem>>> payments;
    private final Optional<List<Optional<CreditNoteAppliedPaymentsItem>>> appliedPayments;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<CreditNoteAccountingPeriod> accountingPeriod;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private CreditNote(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<OffsetDateTime> transactionDate, Optional<CreditNoteStatus> status, Optional<String> number, Optional<CreditNoteContact> contact, Optional<CreditNoteCompany> company, Optional<String> exchangeRate, Optional<Double> totalAmount, Optional<Double> remainingCredit, Optional<Boolean> inclusiveOfTax, Optional<List<CreditNoteLineItem>> lineItems, Optional<List<Optional<CreditNoteTrackingCategoriesItem>>> trackingCategories, Optional<CreditNoteCurrency> currency, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<List<Optional<CreditNotePaymentsItem>>> payments, Optional<List<Optional<CreditNoteAppliedPaymentsItem>>> appliedPayments, Optional<Boolean> remoteWasDeleted, Optional<CreditNoteAccountingPeriod> accountingPeriod, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.transactionDate = transactionDate;
        this.status = status;
        this.number = number;
        this.contact = contact;
        this.company = company;
        this.exchangeRate = exchangeRate;
        this.totalAmount = totalAmount;
        this.remainingCredit = remainingCredit;
        this.inclusiveOfTax = inclusiveOfTax;
        this.lineItems = lineItems;
        this.trackingCategories = trackingCategories;
        this.currency = currency;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.payments = payments;
        this.appliedPayments = appliedPayments;
        this.remoteWasDeleted = remoteWasDeleted;
        this.accountingPeriod = accountingPeriod;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="status")
    public Optional<CreditNoteStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="contact")
    public Optional<CreditNoteContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="company")
    public Optional<CreditNoteCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="remaining_credit")
    public Optional<Double> getRemainingCredit() {
        return this.remainingCredit;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="line_items")
    public Optional<List<CreditNoteLineItem>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<CreditNoteTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="currency")
    public Optional<CreditNoteCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="payments")
    public Optional<List<Optional<CreditNotePaymentsItem>>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="applied_payments")
    public Optional<List<Optional<CreditNoteAppliedPaymentsItem>>> getAppliedPayments() {
        return this.appliedPayments;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="accounting_period")
    public Optional<CreditNoteAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditNote && this.equalTo((CreditNote)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditNote other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.transactionDate.equals(other.transactionDate) && this.status.equals(other.status) && this.number.equals(other.number) && this.contact.equals(other.contact) && this.company.equals(other.company) && this.exchangeRate.equals(other.exchangeRate) && this.totalAmount.equals(other.totalAmount) && this.remainingCredit.equals(other.remainingCredit) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.lineItems.equals(other.lineItems) && this.trackingCategories.equals(other.trackingCategories) && this.currency.equals(other.currency) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.payments.equals(other.payments) && this.appliedPayments.equals(other.appliedPayments) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.accountingPeriod.equals(other.accountingPeriod) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.status, this.number, this.contact, this.company, this.exchangeRate, this.totalAmount, this.remainingCredit, this.inclusiveOfTax, this.lineItems, this.trackingCategories, this.currency, this.remoteCreatedAt, this.remoteUpdatedAt, this.payments, this.appliedPayments, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<CreditNoteStatus> status = Optional.empty();
        private Optional<String> number = Optional.empty();
        private Optional<CreditNoteContact> contact = Optional.empty();
        private Optional<CreditNoteCompany> company = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<Double> remainingCredit = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<List<CreditNoteLineItem>> lineItems = Optional.empty();
        private Optional<List<Optional<CreditNoteTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<CreditNoteCurrency> currency = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<List<Optional<CreditNotePaymentsItem>>> payments = Optional.empty();
        private Optional<List<Optional<CreditNoteAppliedPaymentsItem>>> appliedPayments = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<CreditNoteAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreditNote other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.transactionDate(other.getTransactionDate());
            this.status(other.getStatus());
            this.number(other.getNumber());
            this.contact(other.getContact());
            this.company(other.getCompany());
            this.exchangeRate(other.getExchangeRate());
            this.totalAmount(other.getTotalAmount());
            this.remainingCredit(other.getRemainingCredit());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.lineItems(other.getLineItems());
            this.trackingCategories(other.getTrackingCategories());
            this.currency(other.getCurrency());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.payments(other.getPayments());
            this.appliedPayments(other.getAppliedPayments());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.accountingPeriod(other.getAccountingPeriod());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<CreditNoteStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(CreditNoteStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<CreditNoteContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(CreditNoteContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<CreditNoteCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(CreditNoteCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="remaining_credit", nulls=Nulls.SKIP)
        public Builder remainingCredit(Optional<Double> remainingCredit) {
            this.remainingCredit = remainingCredit;
            return this;
        }

        public Builder remainingCredit(Double remainingCredit) {
            this.remainingCredit = Optional.of(remainingCredit);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<CreditNoteLineItem>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<CreditNoteLineItem> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<CreditNoteTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<CreditNoteTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<CreditNoteCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(CreditNoteCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Optional<CreditNotePaymentsItem>>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Optional<CreditNotePaymentsItem>> payments) {
            this.payments = Optional.of(payments);
            return this;
        }

        @JsonSetter(value="applied_payments", nulls=Nulls.SKIP)
        public Builder appliedPayments(Optional<List<Optional<CreditNoteAppliedPaymentsItem>>> appliedPayments) {
            this.appliedPayments = appliedPayments;
            return this;
        }

        public Builder appliedPayments(List<Optional<CreditNoteAppliedPaymentsItem>> appliedPayments) {
            this.appliedPayments = Optional.of(appliedPayments);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<CreditNoteAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(CreditNoteAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public CreditNote build() {
            return new CreditNote(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.status, this.number, this.contact, this.company, this.exchangeRate, this.totalAmount, this.remainingCredit, this.inclusiveOfTax, this.lineItems, this.trackingCategories, this.currency, this.remoteCreatedAt, this.remoteUpdatedAt, this.payments, this.appliedPayments, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

