/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.CreditNoteLineItemCompany;
import com.merge.api.resources.accounting.types.CreditNoteLineItemItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreditNoteLineItem {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<CreditNoteLineItemItem> item;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> quantity;
    private final Optional<String> memo;
    private final Optional<String> unitPrice;
    private final Optional<String> taxRate;
    private final Optional<String> totalLineAmount;
    private final Optional<String> trackingCategory;
    private final Optional<List<Optional<String>>> trackingCategories;
    private final Optional<String> account;
    private final Optional<CreditNoteLineItemCompany> company;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private CreditNoteLineItem(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<CreditNoteLineItemItem> item, Optional<String> name, Optional<String> description, Optional<String> quantity, Optional<String> memo, Optional<String> unitPrice, Optional<String> taxRate, Optional<String> totalLineAmount, Optional<String> trackingCategory, Optional<List<Optional<String>>> trackingCategories, Optional<String> account, Optional<CreditNoteLineItemCompany> company, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.item = item;
        this.name = name;
        this.description = description;
        this.quantity = quantity;
        this.memo = memo;
        this.unitPrice = unitPrice;
        this.taxRate = taxRate;
        this.totalLineAmount = totalLineAmount;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.account = account;
        this.company = company;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="item")
    public Optional<CreditNoteLineItemItem> getItem() {
        return this.item;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="quantity")
    public Optional<String> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="unit_price")
    public Optional<String> getUnitPrice() {
        return this.unitPrice;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="total_line_amount")
    public Optional<String> getTotalLineAmount() {
        return this.totalLineAmount;
    }

    @JsonProperty(value="tracking_category")
    public Optional<String> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<String>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="account")
    public Optional<String> getAccount() {
        return this.account;
    }

    @JsonProperty(value="company")
    public Optional<CreditNoteLineItemCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditNoteLineItem && this.equalTo((CreditNoteLineItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditNoteLineItem other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.item.equals(other.item) && this.name.equals(other.name) && this.description.equals(other.description) && this.quantity.equals(other.quantity) && this.memo.equals(other.memo) && this.unitPrice.equals(other.unitPrice) && this.taxRate.equals(other.taxRate) && this.totalLineAmount.equals(other.totalLineAmount) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.account.equals(other.account) && this.company.equals(other.company) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.item, this.name, this.description, this.quantity, this.memo, this.unitPrice, this.taxRate, this.totalLineAmount, this.trackingCategory, this.trackingCategories, this.account, this.company, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<CreditNoteLineItemItem> item = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> quantity = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<String> unitPrice = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<String> totalLineAmount = Optional.empty();
        private Optional<String> trackingCategory = Optional.empty();
        private Optional<List<Optional<String>>> trackingCategories = Optional.empty();
        private Optional<String> account = Optional.empty();
        private Optional<CreditNoteLineItemCompany> company = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreditNoteLineItem other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.item(other.getItem());
            this.name(other.getName());
            this.description(other.getDescription());
            this.quantity(other.getQuantity());
            this.memo(other.getMemo());
            this.unitPrice(other.getUnitPrice());
            this.taxRate(other.getTaxRate());
            this.totalLineAmount(other.getTotalLineAmount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.account(other.getAccount());
            this.company(other.getCompany());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="item", nulls=Nulls.SKIP)
        public Builder item(Optional<CreditNoteLineItemItem> item) {
            this.item = item;
            return this;
        }

        public Builder item(CreditNoteLineItemItem item) {
            this.item = Optional.of(item);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<String> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = Optional.of(quantity);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="unit_price", nulls=Nulls.SKIP)
        public Builder unitPrice(Optional<String> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public Builder unitPrice(String unitPrice) {
            this.unitPrice = Optional.of(unitPrice);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="total_line_amount", nulls=Nulls.SKIP)
        public Builder totalLineAmount(Optional<String> totalLineAmount) {
            this.totalLineAmount = totalLineAmount;
            return this;
        }

        public Builder totalLineAmount(String totalLineAmount) {
            this.totalLineAmount = Optional.of(totalLineAmount);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<String> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(String trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<String>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<String>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<String> account) {
            this.account = account;
            return this;
        }

        public Builder account(String account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<CreditNoteLineItemCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(CreditNoteLineItemCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public CreditNoteLineItem build() {
            return new CreditNoteLineItem(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.item, this.name, this.description, this.quantity, this.memo, this.unitPrice, this.taxRate, this.totalLineAmount, this.trackingCategory, this.trackingCategories, this.account, this.company, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

