/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.MethodEnum;
import com.merge.api.resources.accounting.types.MultipartFormFieldRequest;
import com.merge.api.resources.accounting.types.RequestFormatEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DataPassthroughRequest {
    private final MethodEnum method;
    private final String path;
    private final Optional<String> baseUrlOverride;
    private final Optional<String> data;
    private final Optional<List<MultipartFormFieldRequest>> multipartFormData;
    private final Optional<Map<String, JsonNode>> headers;
    private final Optional<RequestFormatEnum> requestFormat;
    private final Optional<Boolean> normalizeResponse;
    private final Map<String, Object> additionalProperties;

    private DataPassthroughRequest(MethodEnum method, String path, Optional<String> baseUrlOverride, Optional<String> data, Optional<List<MultipartFormFieldRequest>> multipartFormData, Optional<Map<String, JsonNode>> headers, Optional<RequestFormatEnum> requestFormat, Optional<Boolean> normalizeResponse, Map<String, Object> additionalProperties) {
        this.method = method;
        this.path = path;
        this.baseUrlOverride = baseUrlOverride;
        this.data = data;
        this.multipartFormData = multipartFormData;
        this.headers = headers;
        this.requestFormat = requestFormat;
        this.normalizeResponse = normalizeResponse;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="method")
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="base_url_override")
    public Optional<String> getBaseUrlOverride() {
        return this.baseUrlOverride;
    }

    @JsonProperty(value="data")
    public Optional<String> getData() {
        return this.data;
    }

    @JsonProperty(value="multipart_form_data")
    public Optional<List<MultipartFormFieldRequest>> getMultipartFormData() {
        return this.multipartFormData;
    }

    @JsonProperty(value="headers")
    public Optional<Map<String, JsonNode>> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="request_format")
    public Optional<RequestFormatEnum> getRequestFormat() {
        return this.requestFormat;
    }

    @JsonProperty(value="normalize_response")
    public Optional<Boolean> getNormalizeResponse() {
        return this.normalizeResponse;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataPassthroughRequest && this.equalTo((DataPassthroughRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataPassthroughRequest other) {
        return this.method.equals((Object)other.method) && this.path.equals(other.path) && this.baseUrlOverride.equals(other.baseUrlOverride) && this.data.equals(other.data) && this.multipartFormData.equals(other.multipartFormData) && this.headers.equals(other.headers) && this.requestFormat.equals(other.requestFormat) && this.normalizeResponse.equals(other.normalizeResponse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.path, this.baseUrlOverride, this.data, this.multipartFormData, this.headers, this.requestFormat, this.normalizeResponse});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MethodStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MethodStage,
    PathStage,
    _FinalStage {
        private MethodEnum method;
        private String path;
        private Optional<Boolean> normalizeResponse = Optional.empty();
        private Optional<RequestFormatEnum> requestFormat = Optional.empty();
        private Optional<Map<String, JsonNode>> headers = Optional.empty();
        private Optional<List<MultipartFormFieldRequest>> multipartFormData = Optional.empty();
        private Optional<String> data = Optional.empty();
        private Optional<String> baseUrlOverride = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataPassthroughRequest other) {
            this.method(other.getMethod());
            this.path(other.getPath());
            this.baseUrlOverride(other.getBaseUrlOverride());
            this.data(other.getData());
            this.multipartFormData(other.getMultipartFormData());
            this.headers(other.getHeaders());
            this.requestFormat(other.getRequestFormat());
            this.normalizeResponse(other.getNormalizeResponse());
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public PathStage method(MethodEnum method) {
            this.method = method;
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public _FinalStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public _FinalStage normalizeResponse(Boolean normalizeResponse) {
            this.normalizeResponse = Optional.of(normalizeResponse);
            return this;
        }

        @Override
        @JsonSetter(value="normalize_response", nulls=Nulls.SKIP)
        public _FinalStage normalizeResponse(Optional<Boolean> normalizeResponse) {
            this.normalizeResponse = normalizeResponse;
            return this;
        }

        @Override
        public _FinalStage requestFormat(RequestFormatEnum requestFormat) {
            this.requestFormat = Optional.of(requestFormat);
            return this;
        }

        @Override
        @JsonSetter(value="request_format", nulls=Nulls.SKIP)
        public _FinalStage requestFormat(Optional<RequestFormatEnum> requestFormat) {
            this.requestFormat = requestFormat;
            return this;
        }

        @Override
        public _FinalStage headers(Map<String, JsonNode> headers) {
            this.headers = Optional.of(headers);
            return this;
        }

        @Override
        @JsonSetter(value="headers", nulls=Nulls.SKIP)
        public _FinalStage headers(Optional<Map<String, JsonNode>> headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public _FinalStage multipartFormData(List<MultipartFormFieldRequest> multipartFormData) {
            this.multipartFormData = Optional.of(multipartFormData);
            return this;
        }

        @Override
        @JsonSetter(value="multipart_form_data", nulls=Nulls.SKIP)
        public _FinalStage multipartFormData(Optional<List<MultipartFormFieldRequest>> multipartFormData) {
            this.multipartFormData = multipartFormData;
            return this;
        }

        @Override
        public _FinalStage data(String data) {
            this.data = Optional.of(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(Optional<String> data) {
            this.data = data;
            return this;
        }

        @Override
        public _FinalStage baseUrlOverride(String baseUrlOverride) {
            this.baseUrlOverride = Optional.of(baseUrlOverride);
            return this;
        }

        @Override
        @JsonSetter(value="base_url_override", nulls=Nulls.SKIP)
        public _FinalStage baseUrlOverride(Optional<String> baseUrlOverride) {
            this.baseUrlOverride = baseUrlOverride;
            return this;
        }

        @Override
        public DataPassthroughRequest build() {
            return new DataPassthroughRequest(this.method, this.path, this.baseUrlOverride, this.data, this.multipartFormData, this.headers, this.requestFormat, this.normalizeResponse, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataPassthroughRequest build();

        public _FinalStage baseUrlOverride(Optional<String> var1);

        public _FinalStage baseUrlOverride(String var1);

        public _FinalStage data(Optional<String> var1);

        public _FinalStage data(String var1);

        public _FinalStage multipartFormData(Optional<List<MultipartFormFieldRequest>> var1);

        public _FinalStage multipartFormData(List<MultipartFormFieldRequest> var1);

        public _FinalStage headers(Optional<Map<String, JsonNode>> var1);

        public _FinalStage headers(Map<String, JsonNode> var1);

        public _FinalStage requestFormat(Optional<RequestFormatEnum> var1);

        public _FinalStage requestFormat(RequestFormatEnum var1);

        public _FinalStage normalizeResponse(Optional<Boolean> var1);

        public _FinalStage normalizeResponse(Boolean var1);
    }

    public static interface PathStage {
        public _FinalStage path(String var1);
    }

    public static interface MethodStage {
        public PathStage method(MethodEnum var1);

        public Builder from(DataPassthroughRequest var1);
    }
}

