/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DebugModelLogSummary {
    private final String url;
    private final String method;
    private final int statusCode;
    private final Map<String, Object> additionalProperties;

    private DebugModelLogSummary(String url, String method, int statusCode, Map<String, Object> additionalProperties) {
        this.url = url;
        this.method = method;
        this.statusCode = statusCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="status_code")
    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DebugModelLogSummary && this.equalTo((DebugModelLogSummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DebugModelLogSummary other) {
        return this.url.equals(other.url) && this.method.equals(other.method) && this.statusCode == other.statusCode;
    }

    public int hashCode() {
        return Objects.hash(this.url, this.method, this.statusCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    MethodStage,
    StatusCodeStage,
    _FinalStage {
        private String url;
        private String method;
        private int statusCode;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DebugModelLogSummary other) {
            this.url(other.getUrl());
            this.method(other.getMethod());
            this.statusCode(other.getStatusCode());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public MethodStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public StatusCodeStage method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @JsonSetter(value="status_code")
        public _FinalStage statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public DebugModelLogSummary build() {
            return new DebugModelLogSummary(this.url, this.method, this.statusCode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DebugModelLogSummary build();
    }

    public static interface StatusCodeStage {
        public _FinalStage statusCode(int var1);
    }

    public static interface MethodStage {
        public StatusCodeStage method(String var1);
    }

    public static interface UrlStage {
        public MethodStage url(String var1);

        public Builder from(DebugModelLogSummary var1);
    }
}

