/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.ExpenseAccount;
import com.merge.api.resources.accounting.types.ExpenseAccountingPeriod;
import com.merge.api.resources.accounting.types.ExpenseCompany;
import com.merge.api.resources.accounting.types.ExpenseContact;
import com.merge.api.resources.accounting.types.ExpenseCurrency;
import com.merge.api.resources.accounting.types.ExpenseLine;
import com.merge.api.resources.accounting.types.ExpenseTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Expense {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<ExpenseAccount> account;
    private final Optional<ExpenseContact> contact;
    private final Optional<Double> totalAmount;
    private final Optional<Double> subTotal;
    private final Optional<Double> totalTaxAmount;
    private final Optional<ExpenseCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<ExpenseCompany> company;
    private final Optional<String> memo;
    private final Optional<List<ExpenseLine>> lines;
    private final Optional<List<Optional<ExpenseTrackingCategoriesItem>>> trackingCategories;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<ExpenseAccountingPeriod> accountingPeriod;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private Expense(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<OffsetDateTime> transactionDate, Optional<OffsetDateTime> remoteCreatedAt, Optional<ExpenseAccount> account, Optional<ExpenseContact> contact, Optional<Double> totalAmount, Optional<Double> subTotal, Optional<Double> totalTaxAmount, Optional<ExpenseCurrency> currency, Optional<String> exchangeRate, Optional<Boolean> inclusiveOfTax, Optional<ExpenseCompany> company, Optional<String> memo, Optional<List<ExpenseLine>> lines, Optional<List<Optional<ExpenseTrackingCategoriesItem>>> trackingCategories, Optional<Boolean> remoteWasDeleted, Optional<ExpenseAccountingPeriod> accountingPeriod, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.transactionDate = transactionDate;
        this.remoteCreatedAt = remoteCreatedAt;
        this.account = account;
        this.contact = contact;
        this.totalAmount = totalAmount;
        this.subTotal = subTotal;
        this.totalTaxAmount = totalTaxAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.inclusiveOfTax = inclusiveOfTax;
        this.company = company;
        this.memo = memo;
        this.lines = lines;
        this.trackingCategories = trackingCategories;
        this.remoteWasDeleted = remoteWasDeleted;
        this.accountingPeriod = accountingPeriod;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="account")
    public Optional<ExpenseAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<ExpenseContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="sub_total")
    public Optional<Double> getSubTotal() {
        return this.subTotal;
    }

    @JsonProperty(value="total_tax_amount")
    public Optional<Double> getTotalTaxAmount() {
        return this.totalTaxAmount;
    }

    @JsonProperty(value="currency")
    public Optional<ExpenseCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="company")
    public Optional<ExpenseCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="lines")
    public Optional<List<ExpenseLine>> getLines() {
        return this.lines;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<ExpenseTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="accounting_period")
    public Optional<ExpenseAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Expense && this.equalTo((Expense)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Expense other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.transactionDate.equals(other.transactionDate) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.totalAmount.equals(other.totalAmount) && this.subTotal.equals(other.subTotal) && this.totalTaxAmount.equals(other.totalTaxAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.company.equals(other.company) && this.memo.equals(other.memo) && this.lines.equals(other.lines) && this.trackingCategories.equals(other.trackingCategories) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.accountingPeriod.equals(other.accountingPeriod) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.remoteCreatedAt, this.account, this.contact, this.totalAmount, this.subTotal, this.totalTaxAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.memo, this.lines, this.trackingCategories, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<ExpenseAccount> account = Optional.empty();
        private Optional<ExpenseContact> contact = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<Double> subTotal = Optional.empty();
        private Optional<Double> totalTaxAmount = Optional.empty();
        private Optional<ExpenseCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<ExpenseCompany> company = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<List<ExpenseLine>> lines = Optional.empty();
        private Optional<List<Optional<ExpenseTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<ExpenseAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Expense other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.transactionDate(other.getTransactionDate());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.totalAmount(other.getTotalAmount());
            this.subTotal(other.getSubTotal());
            this.totalTaxAmount(other.getTotalTaxAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.company(other.getCompany());
            this.memo(other.getMemo());
            this.lines(other.getLines());
            this.trackingCategories(other.getTrackingCategories());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.accountingPeriod(other.getAccountingPeriod());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<ExpenseAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(ExpenseAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<ExpenseContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ExpenseContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="sub_total", nulls=Nulls.SKIP)
        public Builder subTotal(Optional<Double> subTotal) {
            this.subTotal = subTotal;
            return this;
        }

        public Builder subTotal(Double subTotal) {
            this.subTotal = Optional.of(subTotal);
            return this;
        }

        @JsonSetter(value="total_tax_amount", nulls=Nulls.SKIP)
        public Builder totalTaxAmount(Optional<Double> totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public Builder totalTaxAmount(Double totalTaxAmount) {
            this.totalTaxAmount = Optional.of(totalTaxAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<ExpenseCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(ExpenseCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<ExpenseCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(ExpenseCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public Builder lines(Optional<List<ExpenseLine>> lines) {
            this.lines = lines;
            return this;
        }

        public Builder lines(List<ExpenseLine> lines) {
            this.lines = Optional.of(lines);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<ExpenseTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<ExpenseTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<ExpenseAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(ExpenseAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public Expense build() {
            return new Expense(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.remoteCreatedAt, this.account, this.contact, this.totalAmount, this.subTotal, this.totalTaxAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.memo, this.lines, this.trackingCategories, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

