/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.ExpenseLineAccount;
import com.merge.api.resources.accounting.types.ExpenseLineContact;
import com.merge.api.resources.accounting.types.ExpenseLineCurrency;
import com.merge.api.resources.accounting.types.ExpenseLineItem;
import com.merge.api.resources.accounting.types.ExpenseLineTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.ExpenseLineTrackingCategory;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExpenseLine {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<ExpenseLineItem> item;
    private final Optional<Double> netAmount;
    private final Optional<ExpenseLineTrackingCategory> trackingCategory;
    private final Optional<List<Optional<ExpenseLineTrackingCategoriesItem>>> trackingCategories;
    private final Optional<String> company;
    private final Optional<ExpenseLineCurrency> currency;
    private final Optional<ExpenseLineAccount> account;
    private final Optional<ExpenseLineContact> contact;
    private final Optional<String> description;
    private final Optional<String> exchangeRate;
    private final Optional<String> taxRate;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private ExpenseLine(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<ExpenseLineItem> item, Optional<Double> netAmount, Optional<ExpenseLineTrackingCategory> trackingCategory, Optional<List<Optional<ExpenseLineTrackingCategoriesItem>>> trackingCategories, Optional<String> company, Optional<ExpenseLineCurrency> currency, Optional<ExpenseLineAccount> account, Optional<ExpenseLineContact> contact, Optional<String> description, Optional<String> exchangeRate, Optional<String> taxRate, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.item = item;
        this.netAmount = netAmount;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.company = company;
        this.currency = currency;
        this.account = account;
        this.contact = contact;
        this.description = description;
        this.exchangeRate = exchangeRate;
        this.taxRate = taxRate;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="item")
    public Optional<ExpenseLineItem> getItem() {
        return this.item;
    }

    @JsonProperty(value="net_amount")
    public Optional<Double> getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="tracking_category")
    public Optional<ExpenseLineTrackingCategory> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<ExpenseLineTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="currency")
    public Optional<ExpenseLineCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="account")
    public Optional<ExpenseLineAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<ExpenseLineContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExpenseLine && this.equalTo((ExpenseLine)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpenseLine other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.item.equals(other.item) && this.netAmount.equals(other.netAmount) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.company.equals(other.company) && this.currency.equals(other.currency) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.description.equals(other.description) && this.exchangeRate.equals(other.exchangeRate) && this.taxRate.equals(other.taxRate) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.item, this.netAmount, this.trackingCategory, this.trackingCategories, this.company, this.currency, this.account, this.contact, this.description, this.exchangeRate, this.taxRate, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<ExpenseLineItem> item = Optional.empty();
        private Optional<Double> netAmount = Optional.empty();
        private Optional<ExpenseLineTrackingCategory> trackingCategory = Optional.empty();
        private Optional<List<Optional<ExpenseLineTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<ExpenseLineCurrency> currency = Optional.empty();
        private Optional<ExpenseLineAccount> account = Optional.empty();
        private Optional<ExpenseLineContact> contact = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExpenseLine other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.item(other.getItem());
            this.netAmount(other.getNetAmount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.company(other.getCompany());
            this.currency(other.getCurrency());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.description(other.getDescription());
            this.exchangeRate(other.getExchangeRate());
            this.taxRate(other.getTaxRate());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="item", nulls=Nulls.SKIP)
        public Builder item(Optional<ExpenseLineItem> item) {
            this.item = item;
            return this;
        }

        public Builder item(ExpenseLineItem item) {
            this.item = Optional.of(item);
            return this;
        }

        @JsonSetter(value="net_amount", nulls=Nulls.SKIP)
        public Builder netAmount(Optional<Double> netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder netAmount(Double netAmount) {
            this.netAmount = Optional.of(netAmount);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<ExpenseLineTrackingCategory> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(ExpenseLineTrackingCategory trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<ExpenseLineTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<ExpenseLineTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<ExpenseLineCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(ExpenseLineCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<ExpenseLineAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(ExpenseLineAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<ExpenseLineContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ExpenseLineContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public ExpenseLine build() {
            return new ExpenseLine(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.item, this.netAmount, this.trackingCategory, this.trackingCategories, this.company, this.currency, this.account, this.contact, this.description, this.exchangeRate, this.taxRate, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

