/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.ExpenseLineRequestAccount;
import com.merge.api.resources.accounting.types.ExpenseLineRequestContact;
import com.merge.api.resources.accounting.types.ExpenseLineRequestCurrency;
import com.merge.api.resources.accounting.types.ExpenseLineRequestItem;
import com.merge.api.resources.accounting.types.ExpenseLineRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.ExpenseLineRequestTrackingCategory;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExpenseLineRequest {
    private final Optional<String> remoteId;
    private final Optional<ExpenseLineRequestItem> item;
    private final Optional<Double> netAmount;
    private final Optional<ExpenseLineRequestTrackingCategory> trackingCategory;
    private final Optional<List<Optional<ExpenseLineRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<String> company;
    private final Optional<ExpenseLineRequestCurrency> currency;
    private final Optional<ExpenseLineRequestAccount> account;
    private final Optional<ExpenseLineRequestContact> contact;
    private final Optional<String> description;
    private final Optional<String> exchangeRate;
    private final Optional<String> taxRate;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private ExpenseLineRequest(Optional<String> remoteId, Optional<ExpenseLineRequestItem> item, Optional<Double> netAmount, Optional<ExpenseLineRequestTrackingCategory> trackingCategory, Optional<List<Optional<ExpenseLineRequestTrackingCategoriesItem>>> trackingCategories, Optional<String> company, Optional<ExpenseLineRequestCurrency> currency, Optional<ExpenseLineRequestAccount> account, Optional<ExpenseLineRequestContact> contact, Optional<String> description, Optional<String> exchangeRate, Optional<String> taxRate, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.remoteId = remoteId;
        this.item = item;
        this.netAmount = netAmount;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.company = company;
        this.currency = currency;
        this.account = account;
        this.contact = contact;
        this.description = description;
        this.exchangeRate = exchangeRate;
        this.taxRate = taxRate;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="item")
    public Optional<ExpenseLineRequestItem> getItem() {
        return this.item;
    }

    @JsonProperty(value="net_amount")
    public Optional<Double> getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="tracking_category")
    public Optional<ExpenseLineRequestTrackingCategory> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<ExpenseLineRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="currency")
    public Optional<ExpenseLineRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="account")
    public Optional<ExpenseLineRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<ExpenseLineRequestContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExpenseLineRequest && this.equalTo((ExpenseLineRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpenseLineRequest other) {
        return this.remoteId.equals(other.remoteId) && this.item.equals(other.item) && this.netAmount.equals(other.netAmount) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.company.equals(other.company) && this.currency.equals(other.currency) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.description.equals(other.description) && this.exchangeRate.equals(other.exchangeRate) && this.taxRate.equals(other.taxRate) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.remoteId, this.item, this.netAmount, this.trackingCategory, this.trackingCategories, this.company, this.currency, this.account, this.contact, this.description, this.exchangeRate, this.taxRate, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> remoteId = Optional.empty();
        private Optional<ExpenseLineRequestItem> item = Optional.empty();
        private Optional<Double> netAmount = Optional.empty();
        private Optional<ExpenseLineRequestTrackingCategory> trackingCategory = Optional.empty();
        private Optional<List<Optional<ExpenseLineRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<ExpenseLineRequestCurrency> currency = Optional.empty();
        private Optional<ExpenseLineRequestAccount> account = Optional.empty();
        private Optional<ExpenseLineRequestContact> contact = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExpenseLineRequest other) {
            this.remoteId(other.getRemoteId());
            this.item(other.getItem());
            this.netAmount(other.getNetAmount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.company(other.getCompany());
            this.currency(other.getCurrency());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.description(other.getDescription());
            this.exchangeRate(other.getExchangeRate());
            this.taxRate(other.getTaxRate());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="item", nulls=Nulls.SKIP)
        public Builder item(Optional<ExpenseLineRequestItem> item) {
            this.item = item;
            return this;
        }

        public Builder item(ExpenseLineRequestItem item) {
            this.item = Optional.of(item);
            return this;
        }

        @JsonSetter(value="net_amount", nulls=Nulls.SKIP)
        public Builder netAmount(Optional<Double> netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder netAmount(Double netAmount) {
            this.netAmount = Optional.of(netAmount);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<ExpenseLineRequestTrackingCategory> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(ExpenseLineRequestTrackingCategory trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<ExpenseLineRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<ExpenseLineRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<ExpenseLineRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(ExpenseLineRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<ExpenseLineRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(ExpenseLineRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<ExpenseLineRequestContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ExpenseLineRequestContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public ExpenseLineRequest build() {
            return new ExpenseLineRequest(this.remoteId, this.item, this.netAmount, this.trackingCategory, this.trackingCategories, this.company, this.currency, this.account, this.contact, this.description, this.exchangeRate, this.taxRate, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

