/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.ExpenseLineRequest;
import com.merge.api.resources.accounting.types.ExpenseRequestAccount;
import com.merge.api.resources.accounting.types.ExpenseRequestAccountingPeriod;
import com.merge.api.resources.accounting.types.ExpenseRequestCompany;
import com.merge.api.resources.accounting.types.ExpenseRequestContact;
import com.merge.api.resources.accounting.types.ExpenseRequestCurrency;
import com.merge.api.resources.accounting.types.ExpenseRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExpenseRequest {
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<ExpenseRequestAccount> account;
    private final Optional<ExpenseRequestContact> contact;
    private final Optional<Double> totalAmount;
    private final Optional<Double> subTotal;
    private final Optional<Double> totalTaxAmount;
    private final Optional<ExpenseRequestCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<ExpenseRequestCompany> company;
    private final Optional<String> memo;
    private final Optional<List<ExpenseLineRequest>> lines;
    private final Optional<List<Optional<ExpenseRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<ExpenseRequestAccountingPeriod> accountingPeriod;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private ExpenseRequest(Optional<OffsetDateTime> transactionDate, Optional<ExpenseRequestAccount> account, Optional<ExpenseRequestContact> contact, Optional<Double> totalAmount, Optional<Double> subTotal, Optional<Double> totalTaxAmount, Optional<ExpenseRequestCurrency> currency, Optional<String> exchangeRate, Optional<Boolean> inclusiveOfTax, Optional<ExpenseRequestCompany> company, Optional<String> memo, Optional<List<ExpenseLineRequest>> lines, Optional<List<Optional<ExpenseRequestTrackingCategoriesItem>>> trackingCategories, Optional<ExpenseRequestAccountingPeriod> accountingPeriod, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.transactionDate = transactionDate;
        this.account = account;
        this.contact = contact;
        this.totalAmount = totalAmount;
        this.subTotal = subTotal;
        this.totalTaxAmount = totalTaxAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.inclusiveOfTax = inclusiveOfTax;
        this.company = company;
        this.memo = memo;
        this.lines = lines;
        this.trackingCategories = trackingCategories;
        this.accountingPeriod = accountingPeriod;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="account")
    public Optional<ExpenseRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<ExpenseRequestContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="sub_total")
    public Optional<Double> getSubTotal() {
        return this.subTotal;
    }

    @JsonProperty(value="total_tax_amount")
    public Optional<Double> getTotalTaxAmount() {
        return this.totalTaxAmount;
    }

    @JsonProperty(value="currency")
    public Optional<ExpenseRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="company")
    public Optional<ExpenseRequestCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="lines")
    public Optional<List<ExpenseLineRequest>> getLines() {
        return this.lines;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<ExpenseRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="accounting_period")
    public Optional<ExpenseRequestAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExpenseRequest && this.equalTo((ExpenseRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpenseRequest other) {
        return this.transactionDate.equals(other.transactionDate) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.totalAmount.equals(other.totalAmount) && this.subTotal.equals(other.subTotal) && this.totalTaxAmount.equals(other.totalTaxAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.company.equals(other.company) && this.memo.equals(other.memo) && this.lines.equals(other.lines) && this.trackingCategories.equals(other.trackingCategories) && this.accountingPeriod.equals(other.accountingPeriod) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.transactionDate, this.account, this.contact, this.totalAmount, this.subTotal, this.totalTaxAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.memo, this.lines, this.trackingCategories, this.accountingPeriod, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<ExpenseRequestAccount> account = Optional.empty();
        private Optional<ExpenseRequestContact> contact = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<Double> subTotal = Optional.empty();
        private Optional<Double> totalTaxAmount = Optional.empty();
        private Optional<ExpenseRequestCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<ExpenseRequestCompany> company = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<List<ExpenseLineRequest>> lines = Optional.empty();
        private Optional<List<Optional<ExpenseRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<ExpenseRequestAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExpenseRequest other) {
            this.transactionDate(other.getTransactionDate());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.totalAmount(other.getTotalAmount());
            this.subTotal(other.getSubTotal());
            this.totalTaxAmount(other.getTotalTaxAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.company(other.getCompany());
            this.memo(other.getMemo());
            this.lines(other.getLines());
            this.trackingCategories(other.getTrackingCategories());
            this.accountingPeriod(other.getAccountingPeriod());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<ExpenseRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(ExpenseRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<ExpenseRequestContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ExpenseRequestContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="sub_total", nulls=Nulls.SKIP)
        public Builder subTotal(Optional<Double> subTotal) {
            this.subTotal = subTotal;
            return this;
        }

        public Builder subTotal(Double subTotal) {
            this.subTotal = Optional.of(subTotal);
            return this;
        }

        @JsonSetter(value="total_tax_amount", nulls=Nulls.SKIP)
        public Builder totalTaxAmount(Optional<Double> totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public Builder totalTaxAmount(Double totalTaxAmount) {
            this.totalTaxAmount = Optional.of(totalTaxAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<ExpenseRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(ExpenseRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<ExpenseRequestCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(ExpenseRequestCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public Builder lines(Optional<List<ExpenseLineRequest>> lines) {
            this.lines = lines;
            return this;
        }

        public Builder lines(List<ExpenseLineRequest> lines) {
            this.lines = Optional.of(lines);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<ExpenseRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<ExpenseRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<ExpenseRequestAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(ExpenseRequestAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public ExpenseRequest build() {
            return new ExpenseRequest(this.transactionDate, this.account, this.contact, this.totalAmount, this.subTotal, this.totalTaxAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.memo, this.lines, this.trackingCategories, this.accountingPeriod, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

