/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.IncomeStatementCompany;
import com.merge.api.resources.accounting.types.IncomeStatementCurrency;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.ReportItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class IncomeStatement {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<IncomeStatementCurrency> currency;
    private final Optional<IncomeStatementCompany> company;
    private final Optional<OffsetDateTime> startPeriod;
    private final Optional<OffsetDateTime> endPeriod;
    private final Optional<List<ReportItem>> income;
    private final Optional<List<ReportItem>> costOfSales;
    private final Optional<Double> grossProfit;
    private final Optional<List<ReportItem>> operatingExpenses;
    private final Optional<Double> netOperatingIncome;
    private final Optional<List<ReportItem>> nonOperatingExpenses;
    private final Optional<Double> netIncome;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private IncomeStatement(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<IncomeStatementCurrency> currency, Optional<IncomeStatementCompany> company, Optional<OffsetDateTime> startPeriod, Optional<OffsetDateTime> endPeriod, Optional<List<ReportItem>> income, Optional<List<ReportItem>> costOfSales, Optional<Double> grossProfit, Optional<List<ReportItem>> operatingExpenses, Optional<Double> netOperatingIncome, Optional<List<ReportItem>> nonOperatingExpenses, Optional<Double> netIncome, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.currency = currency;
        this.company = company;
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
        this.income = income;
        this.costOfSales = costOfSales;
        this.grossProfit = grossProfit;
        this.operatingExpenses = operatingExpenses;
        this.netOperatingIncome = netOperatingIncome;
        this.nonOperatingExpenses = nonOperatingExpenses;
        this.netIncome = netIncome;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="currency")
    public Optional<IncomeStatementCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="company")
    public Optional<IncomeStatementCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="start_period")
    public Optional<OffsetDateTime> getStartPeriod() {
        return this.startPeriod;
    }

    @JsonProperty(value="end_period")
    public Optional<OffsetDateTime> getEndPeriod() {
        return this.endPeriod;
    }

    @JsonProperty(value="income")
    public Optional<List<ReportItem>> getIncome() {
        return this.income;
    }

    @JsonProperty(value="cost_of_sales")
    public Optional<List<ReportItem>> getCostOfSales() {
        return this.costOfSales;
    }

    @JsonProperty(value="gross_profit")
    public Optional<Double> getGrossProfit() {
        return this.grossProfit;
    }

    @JsonProperty(value="operating_expenses")
    public Optional<List<ReportItem>> getOperatingExpenses() {
        return this.operatingExpenses;
    }

    @JsonProperty(value="net_operating_income")
    public Optional<Double> getNetOperatingIncome() {
        return this.netOperatingIncome;
    }

    @JsonProperty(value="non_operating_expenses")
    public Optional<List<ReportItem>> getNonOperatingExpenses() {
        return this.nonOperatingExpenses;
    }

    @JsonProperty(value="net_income")
    public Optional<Double> getNetIncome() {
        return this.netIncome;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IncomeStatement && this.equalTo((IncomeStatement)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IncomeStatement other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.currency.equals(other.currency) && this.company.equals(other.company) && this.startPeriod.equals(other.startPeriod) && this.endPeriod.equals(other.endPeriod) && this.income.equals(other.income) && this.costOfSales.equals(other.costOfSales) && this.grossProfit.equals(other.grossProfit) && this.operatingExpenses.equals(other.operatingExpenses) && this.netOperatingIncome.equals(other.netOperatingIncome) && this.nonOperatingExpenses.equals(other.nonOperatingExpenses) && this.netIncome.equals(other.netIncome) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.startPeriod, this.endPeriod, this.income, this.costOfSales, this.grossProfit, this.operatingExpenses, this.netOperatingIncome, this.nonOperatingExpenses, this.netIncome, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<IncomeStatementCurrency> currency = Optional.empty();
        private Optional<IncomeStatementCompany> company = Optional.empty();
        private Optional<OffsetDateTime> startPeriod = Optional.empty();
        private Optional<OffsetDateTime> endPeriod = Optional.empty();
        private Optional<List<ReportItem>> income = Optional.empty();
        private Optional<List<ReportItem>> costOfSales = Optional.empty();
        private Optional<Double> grossProfit = Optional.empty();
        private Optional<List<ReportItem>> operatingExpenses = Optional.empty();
        private Optional<Double> netOperatingIncome = Optional.empty();
        private Optional<List<ReportItem>> nonOperatingExpenses = Optional.empty();
        private Optional<Double> netIncome = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(IncomeStatement other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.currency(other.getCurrency());
            this.company(other.getCompany());
            this.startPeriod(other.getStartPeriod());
            this.endPeriod(other.getEndPeriod());
            this.income(other.getIncome());
            this.costOfSales(other.getCostOfSales());
            this.grossProfit(other.getGrossProfit());
            this.operatingExpenses(other.getOperatingExpenses());
            this.netOperatingIncome(other.getNetOperatingIncome());
            this.nonOperatingExpenses(other.getNonOperatingExpenses());
            this.netIncome(other.getNetIncome());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<IncomeStatementCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(IncomeStatementCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<IncomeStatementCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(IncomeStatementCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="start_period", nulls=Nulls.SKIP)
        public Builder startPeriod(Optional<OffsetDateTime> startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        public Builder startPeriod(OffsetDateTime startPeriod) {
            this.startPeriod = Optional.of(startPeriod);
            return this;
        }

        @JsonSetter(value="end_period", nulls=Nulls.SKIP)
        public Builder endPeriod(Optional<OffsetDateTime> endPeriod) {
            this.endPeriod = endPeriod;
            return this;
        }

        public Builder endPeriod(OffsetDateTime endPeriod) {
            this.endPeriod = Optional.of(endPeriod);
            return this;
        }

        @JsonSetter(value="income", nulls=Nulls.SKIP)
        public Builder income(Optional<List<ReportItem>> income) {
            this.income = income;
            return this;
        }

        public Builder income(List<ReportItem> income) {
            this.income = Optional.of(income);
            return this;
        }

        @JsonSetter(value="cost_of_sales", nulls=Nulls.SKIP)
        public Builder costOfSales(Optional<List<ReportItem>> costOfSales) {
            this.costOfSales = costOfSales;
            return this;
        }

        public Builder costOfSales(List<ReportItem> costOfSales) {
            this.costOfSales = Optional.of(costOfSales);
            return this;
        }

        @JsonSetter(value="gross_profit", nulls=Nulls.SKIP)
        public Builder grossProfit(Optional<Double> grossProfit) {
            this.grossProfit = grossProfit;
            return this;
        }

        public Builder grossProfit(Double grossProfit) {
            this.grossProfit = Optional.of(grossProfit);
            return this;
        }

        @JsonSetter(value="operating_expenses", nulls=Nulls.SKIP)
        public Builder operatingExpenses(Optional<List<ReportItem>> operatingExpenses) {
            this.operatingExpenses = operatingExpenses;
            return this;
        }

        public Builder operatingExpenses(List<ReportItem> operatingExpenses) {
            this.operatingExpenses = Optional.of(operatingExpenses);
            return this;
        }

        @JsonSetter(value="net_operating_income", nulls=Nulls.SKIP)
        public Builder netOperatingIncome(Optional<Double> netOperatingIncome) {
            this.netOperatingIncome = netOperatingIncome;
            return this;
        }

        public Builder netOperatingIncome(Double netOperatingIncome) {
            this.netOperatingIncome = Optional.of(netOperatingIncome);
            return this;
        }

        @JsonSetter(value="non_operating_expenses", nulls=Nulls.SKIP)
        public Builder nonOperatingExpenses(Optional<List<ReportItem>> nonOperatingExpenses) {
            this.nonOperatingExpenses = nonOperatingExpenses;
            return this;
        }

        public Builder nonOperatingExpenses(List<ReportItem> nonOperatingExpenses) {
            this.nonOperatingExpenses = Optional.of(nonOperatingExpenses);
            return this;
        }

        @JsonSetter(value="net_income", nulls=Nulls.SKIP)
        public Builder netIncome(Optional<Double> netIncome) {
            this.netIncome = netIncome;
            return this;
        }

        public Builder netIncome(Double netIncome) {
            this.netIncome = Optional.of(netIncome);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public IncomeStatement build() {
            return new IncomeStatement(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.currency, this.company, this.startPeriod, this.endPeriod, this.income, this.costOfSales, this.grossProfit, this.operatingExpenses, this.netOperatingIncome, this.nonOperatingExpenses, this.netIncome, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

