/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.FieldPermissionDeserializerRequest;
import com.merge.api.resources.accounting.types.ModelPermissionDeserializerRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class IndividualCommonModelScopeDeserializerRequest {
    private final String modelName;
    private final Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions;
    private final Optional<FieldPermissionDeserializerRequest> fieldPermissions;
    private final Map<String, Object> additionalProperties;

    private IndividualCommonModelScopeDeserializerRequest(String modelName, Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions, Optional<FieldPermissionDeserializerRequest> fieldPermissions, Map<String, Object> additionalProperties) {
        this.modelName = modelName;
        this.modelPermissions = modelPermissions;
        this.fieldPermissions = fieldPermissions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model_name")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="model_permissions")
    public Optional<Map<String, ModelPermissionDeserializerRequest>> getModelPermissions() {
        return this.modelPermissions;
    }

    @JsonProperty(value="field_permissions")
    public Optional<FieldPermissionDeserializerRequest> getFieldPermissions() {
        return this.fieldPermissions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IndividualCommonModelScopeDeserializerRequest && this.equalTo((IndividualCommonModelScopeDeserializerRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IndividualCommonModelScopeDeserializerRequest other) {
        return this.modelName.equals(other.modelName) && this.modelPermissions.equals(other.modelPermissions) && this.fieldPermissions.equals(other.fieldPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.modelName, this.modelPermissions, this.fieldPermissions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelNameStage,
    _FinalStage {
        private String modelName;
        private Optional<FieldPermissionDeserializerRequest> fieldPermissions = Optional.empty();
        private Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(IndividualCommonModelScopeDeserializerRequest other) {
            this.modelName(other.getModelName());
            this.modelPermissions(other.getModelPermissions());
            this.fieldPermissions(other.getFieldPermissions());
            return this;
        }

        @Override
        @JsonSetter(value="model_name")
        public _FinalStage modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        public _FinalStage fieldPermissions(FieldPermissionDeserializerRequest fieldPermissions) {
            this.fieldPermissions = Optional.of(fieldPermissions);
            return this;
        }

        @Override
        @JsonSetter(value="field_permissions", nulls=Nulls.SKIP)
        public _FinalStage fieldPermissions(Optional<FieldPermissionDeserializerRequest> fieldPermissions) {
            this.fieldPermissions = fieldPermissions;
            return this;
        }

        @Override
        public _FinalStage modelPermissions(Map<String, ModelPermissionDeserializerRequest> modelPermissions) {
            this.modelPermissions = Optional.of(modelPermissions);
            return this;
        }

        @Override
        @JsonSetter(value="model_permissions", nulls=Nulls.SKIP)
        public _FinalStage modelPermissions(Optional<Map<String, ModelPermissionDeserializerRequest>> modelPermissions) {
            this.modelPermissions = modelPermissions;
            return this;
        }

        @Override
        public IndividualCommonModelScopeDeserializerRequest build() {
            return new IndividualCommonModelScopeDeserializerRequest(this.modelName, this.modelPermissions, this.fieldPermissions, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public IndividualCommonModelScopeDeserializerRequest build();

        public _FinalStage modelPermissions(Optional<Map<String, ModelPermissionDeserializerRequest>> var1);

        public _FinalStage modelPermissions(Map<String, ModelPermissionDeserializerRequest> var1);

        public _FinalStage fieldPermissions(Optional<FieldPermissionDeserializerRequest> var1);

        public _FinalStage fieldPermissions(FieldPermissionDeserializerRequest var1);
    }

    public static interface ModelNameStage {
        public _FinalStage modelName(String var1);

        public Builder from(IndividualCommonModelScopeDeserializerRequest var1);
    }
}

