/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.InvoiceAccountingPeriod;
import com.merge.api.resources.accounting.types.InvoiceAppliedPaymentsItem;
import com.merge.api.resources.accounting.types.InvoiceCompany;
import com.merge.api.resources.accounting.types.InvoiceContact;
import com.merge.api.resources.accounting.types.InvoiceCurrency;
import com.merge.api.resources.accounting.types.InvoiceLineItem;
import com.merge.api.resources.accounting.types.InvoicePaymentsItem;
import com.merge.api.resources.accounting.types.InvoicePurchaseOrdersItem;
import com.merge.api.resources.accounting.types.InvoiceStatus;
import com.merge.api.resources.accounting.types.InvoiceTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.InvoiceType;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Invoice {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<InvoiceType> type;
    private final Optional<InvoiceContact> contact;
    private final Optional<String> number;
    private final Optional<OffsetDateTime> issueDate;
    private final Optional<OffsetDateTime> dueDate;
    private final Optional<OffsetDateTime> paidOnDate;
    private final Optional<String> memo;
    private final Optional<InvoiceCompany> company;
    private final Optional<InvoiceCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<Double> totalDiscount;
    private final Optional<Double> subTotal;
    private final Optional<InvoiceStatus> status;
    private final Optional<Double> totalTaxAmount;
    private final Optional<Double> totalAmount;
    private final Optional<Double> balance;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<List<Optional<InvoiceTrackingCategoriesItem>>> trackingCategories;
    private final Optional<InvoiceAccountingPeriod> accountingPeriod;
    private final Optional<List<Optional<InvoicePurchaseOrdersItem>>> purchaseOrders;
    private final Optional<List<Optional<InvoicePaymentsItem>>> payments;
    private final Optional<List<Optional<InvoiceAppliedPaymentsItem>>> appliedPayments;
    private final Optional<List<InvoiceLineItem>> lineItems;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private Invoice(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<InvoiceType> type, Optional<InvoiceContact> contact, Optional<String> number, Optional<OffsetDateTime> issueDate, Optional<OffsetDateTime> dueDate, Optional<OffsetDateTime> paidOnDate, Optional<String> memo, Optional<InvoiceCompany> company, Optional<InvoiceCurrency> currency, Optional<String> exchangeRate, Optional<Double> totalDiscount, Optional<Double> subTotal, Optional<InvoiceStatus> status, Optional<Double> totalTaxAmount, Optional<Double> totalAmount, Optional<Double> balance, Optional<OffsetDateTime> remoteUpdatedAt, Optional<List<Optional<InvoiceTrackingCategoriesItem>>> trackingCategories, Optional<InvoiceAccountingPeriod> accountingPeriod, Optional<List<Optional<InvoicePurchaseOrdersItem>>> purchaseOrders, Optional<List<Optional<InvoicePaymentsItem>>> payments, Optional<List<Optional<InvoiceAppliedPaymentsItem>>> appliedPayments, Optional<List<InvoiceLineItem>> lineItems, Optional<Boolean> inclusiveOfTax, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.type = type;
        this.contact = contact;
        this.number = number;
        this.issueDate = issueDate;
        this.dueDate = dueDate;
        this.paidOnDate = paidOnDate;
        this.memo = memo;
        this.company = company;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.totalDiscount = totalDiscount;
        this.subTotal = subTotal;
        this.status = status;
        this.totalTaxAmount = totalTaxAmount;
        this.totalAmount = totalAmount;
        this.balance = balance;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.trackingCategories = trackingCategories;
        this.accountingPeriod = accountingPeriod;
        this.purchaseOrders = purchaseOrders;
        this.payments = payments;
        this.appliedPayments = appliedPayments;
        this.lineItems = lineItems;
        this.inclusiveOfTax = inclusiveOfTax;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="type")
    public Optional<InvoiceType> getType() {
        return this.type;
    }

    @JsonProperty(value="contact")
    public Optional<InvoiceContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="issue_date")
    public Optional<OffsetDateTime> getIssueDate() {
        return this.issueDate;
    }

    @JsonProperty(value="due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="paid_on_date")
    public Optional<OffsetDateTime> getPaidOnDate() {
        return this.paidOnDate;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="company")
    public Optional<InvoiceCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="currency")
    public Optional<InvoiceCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="total_discount")
    public Optional<Double> getTotalDiscount() {
        return this.totalDiscount;
    }

    @JsonProperty(value="sub_total")
    public Optional<Double> getSubTotal() {
        return this.subTotal;
    }

    @JsonProperty(value="status")
    public Optional<InvoiceStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="total_tax_amount")
    public Optional<Double> getTotalTaxAmount() {
        return this.totalTaxAmount;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="balance")
    public Optional<Double> getBalance() {
        return this.balance;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<InvoiceTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="accounting_period")
    public Optional<InvoiceAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="purchase_orders")
    public Optional<List<Optional<InvoicePurchaseOrdersItem>>> getPurchaseOrders() {
        return this.purchaseOrders;
    }

    @JsonProperty(value="payments")
    public Optional<List<Optional<InvoicePaymentsItem>>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="applied_payments")
    public Optional<List<Optional<InvoiceAppliedPaymentsItem>>> getAppliedPayments() {
        return this.appliedPayments;
    }

    @JsonProperty(value="line_items")
    public Optional<List<InvoiceLineItem>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Invoice && this.equalTo((Invoice)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Invoice other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.type.equals(other.type) && this.contact.equals(other.contact) && this.number.equals(other.number) && this.issueDate.equals(other.issueDate) && this.dueDate.equals(other.dueDate) && this.paidOnDate.equals(other.paidOnDate) && this.memo.equals(other.memo) && this.company.equals(other.company) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.totalDiscount.equals(other.totalDiscount) && this.subTotal.equals(other.subTotal) && this.status.equals(other.status) && this.totalTaxAmount.equals(other.totalTaxAmount) && this.totalAmount.equals(other.totalAmount) && this.balance.equals(other.balance) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.trackingCategories.equals(other.trackingCategories) && this.accountingPeriod.equals(other.accountingPeriod) && this.purchaseOrders.equals(other.purchaseOrders) && this.payments.equals(other.payments) && this.appliedPayments.equals(other.appliedPayments) && this.lineItems.equals(other.lineItems) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.type, this.contact, this.number, this.issueDate, this.dueDate, this.paidOnDate, this.memo, this.company, this.currency, this.exchangeRate, this.totalDiscount, this.subTotal, this.status, this.totalTaxAmount, this.totalAmount, this.balance, this.remoteUpdatedAt, this.trackingCategories, this.accountingPeriod, this.purchaseOrders, this.payments, this.appliedPayments, this.lineItems, this.inclusiveOfTax, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<InvoiceType> type = Optional.empty();
        private Optional<InvoiceContact> contact = Optional.empty();
        private Optional<String> number = Optional.empty();
        private Optional<OffsetDateTime> issueDate = Optional.empty();
        private Optional<OffsetDateTime> dueDate = Optional.empty();
        private Optional<OffsetDateTime> paidOnDate = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<InvoiceCompany> company = Optional.empty();
        private Optional<InvoiceCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Double> totalDiscount = Optional.empty();
        private Optional<Double> subTotal = Optional.empty();
        private Optional<InvoiceStatus> status = Optional.empty();
        private Optional<Double> totalTaxAmount = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<Double> balance = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<List<Optional<InvoiceTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<InvoiceAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<List<Optional<InvoicePurchaseOrdersItem>>> purchaseOrders = Optional.empty();
        private Optional<List<Optional<InvoicePaymentsItem>>> payments = Optional.empty();
        private Optional<List<Optional<InvoiceAppliedPaymentsItem>>> appliedPayments = Optional.empty();
        private Optional<List<InvoiceLineItem>> lineItems = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Invoice other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.type(other.getType());
            this.contact(other.getContact());
            this.number(other.getNumber());
            this.issueDate(other.getIssueDate());
            this.dueDate(other.getDueDate());
            this.paidOnDate(other.getPaidOnDate());
            this.memo(other.getMemo());
            this.company(other.getCompany());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.totalDiscount(other.getTotalDiscount());
            this.subTotal(other.getSubTotal());
            this.status(other.getStatus());
            this.totalTaxAmount(other.getTotalTaxAmount());
            this.totalAmount(other.getTotalAmount());
            this.balance(other.getBalance());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.trackingCategories(other.getTrackingCategories());
            this.accountingPeriod(other.getAccountingPeriod());
            this.purchaseOrders(other.getPurchaseOrders());
            this.payments(other.getPayments());
            this.appliedPayments(other.getAppliedPayments());
            this.lineItems(other.getLineItems());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<InvoiceType> type) {
            this.type = type;
            return this;
        }

        public Builder type(InvoiceType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<InvoiceContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(InvoiceContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="issue_date", nulls=Nulls.SKIP)
        public Builder issueDate(Optional<OffsetDateTime> issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public Builder issueDate(OffsetDateTime issueDate) {
            this.issueDate = Optional.of(issueDate);
            return this;
        }

        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public Builder dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.of(dueDate);
            return this;
        }

        @JsonSetter(value="paid_on_date", nulls=Nulls.SKIP)
        public Builder paidOnDate(Optional<OffsetDateTime> paidOnDate) {
            this.paidOnDate = paidOnDate;
            return this;
        }

        public Builder paidOnDate(OffsetDateTime paidOnDate) {
            this.paidOnDate = Optional.of(paidOnDate);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<InvoiceCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(InvoiceCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<InvoiceCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(InvoiceCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="total_discount", nulls=Nulls.SKIP)
        public Builder totalDiscount(Optional<Double> totalDiscount) {
            this.totalDiscount = totalDiscount;
            return this;
        }

        public Builder totalDiscount(Double totalDiscount) {
            this.totalDiscount = Optional.of(totalDiscount);
            return this;
        }

        @JsonSetter(value="sub_total", nulls=Nulls.SKIP)
        public Builder subTotal(Optional<Double> subTotal) {
            this.subTotal = subTotal;
            return this;
        }

        public Builder subTotal(Double subTotal) {
            this.subTotal = Optional.of(subTotal);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<InvoiceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(InvoiceStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="total_tax_amount", nulls=Nulls.SKIP)
        public Builder totalTaxAmount(Optional<Double> totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public Builder totalTaxAmount(Double totalTaxAmount) {
            this.totalTaxAmount = Optional.of(totalTaxAmount);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="balance", nulls=Nulls.SKIP)
        public Builder balance(Optional<Double> balance) {
            this.balance = balance;
            return this;
        }

        public Builder balance(Double balance) {
            this.balance = Optional.of(balance);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<InvoiceTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<InvoiceTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<InvoiceAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(InvoiceAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="purchase_orders", nulls=Nulls.SKIP)
        public Builder purchaseOrders(Optional<List<Optional<InvoicePurchaseOrdersItem>>> purchaseOrders) {
            this.purchaseOrders = purchaseOrders;
            return this;
        }

        public Builder purchaseOrders(List<Optional<InvoicePurchaseOrdersItem>> purchaseOrders) {
            this.purchaseOrders = Optional.of(purchaseOrders);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Optional<InvoicePaymentsItem>>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Optional<InvoicePaymentsItem>> payments) {
            this.payments = Optional.of(payments);
            return this;
        }

        @JsonSetter(value="applied_payments", nulls=Nulls.SKIP)
        public Builder appliedPayments(Optional<List<Optional<InvoiceAppliedPaymentsItem>>> appliedPayments) {
            this.appliedPayments = appliedPayments;
            return this;
        }

        public Builder appliedPayments(List<Optional<InvoiceAppliedPaymentsItem>> appliedPayments) {
            this.appliedPayments = Optional.of(appliedPayments);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<InvoiceLineItem>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<InvoiceLineItem> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.type, this.contact, this.number, this.issueDate, this.dueDate, this.paidOnDate, this.memo, this.company, this.currency, this.exchangeRate, this.totalDiscount, this.subTotal, this.status, this.totalTaxAmount, this.totalAmount, this.balance, this.remoteUpdatedAt, this.trackingCategories, this.accountingPeriod, this.purchaseOrders, this.payments, this.appliedPayments, this.lineItems, this.inclusiveOfTax, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

