/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequestAccount;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequestCurrency;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequestItem;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequestTrackingCategory;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceLineItemRequest {
    private final Optional<String> remoteId;
    private final Optional<String> description;
    private final Optional<Double> unitPrice;
    private final Optional<Double> quantity;
    private final Optional<Double> totalAmount;
    private final Optional<InvoiceLineItemRequestCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<InvoiceLineItemRequestItem> item;
    private final Optional<InvoiceLineItemRequestAccount> account;
    private final Optional<String> taxRate;
    private final Optional<InvoiceLineItemRequestTrackingCategory> trackingCategory;
    private final Optional<List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<String> company;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private InvoiceLineItemRequest(Optional<String> remoteId, Optional<String> description, Optional<Double> unitPrice, Optional<Double> quantity, Optional<Double> totalAmount, Optional<InvoiceLineItemRequestCurrency> currency, Optional<String> exchangeRate, Optional<InvoiceLineItemRequestItem> item, Optional<InvoiceLineItemRequestAccount> account, Optional<String> taxRate, Optional<InvoiceLineItemRequestTrackingCategory> trackingCategory, Optional<List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>>> trackingCategories, Optional<String> company, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.remoteId = remoteId;
        this.description = description;
        this.unitPrice = unitPrice;
        this.quantity = quantity;
        this.totalAmount = totalAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.item = item;
        this.account = account;
        this.taxRate = taxRate;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.company = company;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="unit_price")
    public Optional<Double> getUnitPrice() {
        return this.unitPrice;
    }

    @JsonProperty(value="quantity")
    public Optional<Double> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="currency")
    public Optional<InvoiceLineItemRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="item")
    public Optional<InvoiceLineItemRequestItem> getItem() {
        return this.item;
    }

    @JsonProperty(value="account")
    public Optional<InvoiceLineItemRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="tracking_category")
    public Optional<InvoiceLineItemRequestTrackingCategory> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceLineItemRequest && this.equalTo((InvoiceLineItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceLineItemRequest other) {
        return this.remoteId.equals(other.remoteId) && this.description.equals(other.description) && this.unitPrice.equals(other.unitPrice) && this.quantity.equals(other.quantity) && this.totalAmount.equals(other.totalAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.item.equals(other.item) && this.account.equals(other.account) && this.taxRate.equals(other.taxRate) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.company.equals(other.company) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.remoteId, this.description, this.unitPrice, this.quantity, this.totalAmount, this.currency, this.exchangeRate, this.item, this.account, this.taxRate, this.trackingCategory, this.trackingCategories, this.company, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> remoteId = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Double> unitPrice = Optional.empty();
        private Optional<Double> quantity = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<InvoiceLineItemRequestCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<InvoiceLineItemRequestItem> item = Optional.empty();
        private Optional<InvoiceLineItemRequestAccount> account = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<InvoiceLineItemRequestTrackingCategory> trackingCategory = Optional.empty();
        private Optional<List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceLineItemRequest other) {
            this.remoteId(other.getRemoteId());
            this.description(other.getDescription());
            this.unitPrice(other.getUnitPrice());
            this.quantity(other.getQuantity());
            this.totalAmount(other.getTotalAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.item(other.getItem());
            this.account(other.getAccount());
            this.taxRate(other.getTaxRate());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.company(other.getCompany());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="unit_price", nulls=Nulls.SKIP)
        public Builder unitPrice(Optional<Double> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public Builder unitPrice(Double unitPrice) {
            this.unitPrice = Optional.of(unitPrice);
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<Double> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(Double quantity) {
            this.quantity = Optional.of(quantity);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<InvoiceLineItemRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(InvoiceLineItemRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="item", nulls=Nulls.SKIP)
        public Builder item(Optional<InvoiceLineItemRequestItem> item) {
            this.item = item;
            return this;
        }

        public Builder item(InvoiceLineItemRequestItem item) {
            this.item = Optional.of(item);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<InvoiceLineItemRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(InvoiceLineItemRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<InvoiceLineItemRequestTrackingCategory> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(InvoiceLineItemRequestTrackingCategory trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<InvoiceLineItemRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public InvoiceLineItemRequest build() {
            return new InvoiceLineItemRequest(this.remoteId, this.description, this.unitPrice, this.quantity, this.totalAmount, this.currency, this.exchangeRate, this.item, this.account, this.taxRate, this.trackingCategory, this.trackingCategories, this.company, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

