/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.InvoiceLineItemRequest;
import com.merge.api.resources.accounting.types.InvoiceRequestCompany;
import com.merge.api.resources.accounting.types.InvoiceRequestContact;
import com.merge.api.resources.accounting.types.InvoiceRequestCurrency;
import com.merge.api.resources.accounting.types.InvoiceRequestPaymentsItem;
import com.merge.api.resources.accounting.types.InvoiceRequestPurchaseOrdersItem;
import com.merge.api.resources.accounting.types.InvoiceRequestStatus;
import com.merge.api.resources.accounting.types.InvoiceRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.InvoiceRequestType;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceRequest {
    private final Optional<InvoiceRequestType> type;
    private final Optional<InvoiceRequestContact> contact;
    private final Optional<String> number;
    private final Optional<OffsetDateTime> issueDate;
    private final Optional<OffsetDateTime> dueDate;
    private final Optional<OffsetDateTime> paidOnDate;
    private final Optional<String> memo;
    private final Optional<InvoiceRequestStatus> status;
    private final Optional<InvoiceRequestCompany> company;
    private final Optional<InvoiceRequestCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<Double> totalDiscount;
    private final Optional<Double> subTotal;
    private final Optional<Double> totalTaxAmount;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<Double> totalAmount;
    private final Optional<Double> balance;
    private final Optional<List<Optional<InvoiceRequestPaymentsItem>>> payments;
    private final Optional<List<Optional<InvoiceRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<List<InvoiceLineItemRequest>> lineItems;
    private final Optional<List<Optional<InvoiceRequestPurchaseOrdersItem>>> purchaseOrders;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private InvoiceRequest(Optional<InvoiceRequestType> type, Optional<InvoiceRequestContact> contact, Optional<String> number, Optional<OffsetDateTime> issueDate, Optional<OffsetDateTime> dueDate, Optional<OffsetDateTime> paidOnDate, Optional<String> memo, Optional<InvoiceRequestStatus> status, Optional<InvoiceRequestCompany> company, Optional<InvoiceRequestCurrency> currency, Optional<String> exchangeRate, Optional<Double> totalDiscount, Optional<Double> subTotal, Optional<Double> totalTaxAmount, Optional<Boolean> inclusiveOfTax, Optional<Double> totalAmount, Optional<Double> balance, Optional<List<Optional<InvoiceRequestPaymentsItem>>> payments, Optional<List<Optional<InvoiceRequestTrackingCategoriesItem>>> trackingCategories, Optional<List<InvoiceLineItemRequest>> lineItems, Optional<List<Optional<InvoiceRequestPurchaseOrdersItem>>> purchaseOrders, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.type = type;
        this.contact = contact;
        this.number = number;
        this.issueDate = issueDate;
        this.dueDate = dueDate;
        this.paidOnDate = paidOnDate;
        this.memo = memo;
        this.status = status;
        this.company = company;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.totalDiscount = totalDiscount;
        this.subTotal = subTotal;
        this.totalTaxAmount = totalTaxAmount;
        this.inclusiveOfTax = inclusiveOfTax;
        this.totalAmount = totalAmount;
        this.balance = balance;
        this.payments = payments;
        this.trackingCategories = trackingCategories;
        this.lineItems = lineItems;
        this.purchaseOrders = purchaseOrders;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<InvoiceRequestType> getType() {
        return this.type;
    }

    @JsonProperty(value="contact")
    public Optional<InvoiceRequestContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="issue_date")
    public Optional<OffsetDateTime> getIssueDate() {
        return this.issueDate;
    }

    @JsonProperty(value="due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="paid_on_date")
    public Optional<OffsetDateTime> getPaidOnDate() {
        return this.paidOnDate;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="status")
    public Optional<InvoiceRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="company")
    public Optional<InvoiceRequestCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="currency")
    public Optional<InvoiceRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="total_discount")
    public Optional<Double> getTotalDiscount() {
        return this.totalDiscount;
    }

    @JsonProperty(value="sub_total")
    public Optional<Double> getSubTotal() {
        return this.subTotal;
    }

    @JsonProperty(value="total_tax_amount")
    public Optional<Double> getTotalTaxAmount() {
        return this.totalTaxAmount;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="balance")
    public Optional<Double> getBalance() {
        return this.balance;
    }

    @JsonProperty(value="payments")
    public Optional<List<Optional<InvoiceRequestPaymentsItem>>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<InvoiceRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="line_items")
    public Optional<List<InvoiceLineItemRequest>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="purchase_orders")
    public Optional<List<Optional<InvoiceRequestPurchaseOrdersItem>>> getPurchaseOrders() {
        return this.purchaseOrders;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceRequest && this.equalTo((InvoiceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceRequest other) {
        return this.type.equals(other.type) && this.contact.equals(other.contact) && this.number.equals(other.number) && this.issueDate.equals(other.issueDate) && this.dueDate.equals(other.dueDate) && this.paidOnDate.equals(other.paidOnDate) && this.memo.equals(other.memo) && this.status.equals(other.status) && this.company.equals(other.company) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.totalDiscount.equals(other.totalDiscount) && this.subTotal.equals(other.subTotal) && this.totalTaxAmount.equals(other.totalTaxAmount) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.totalAmount.equals(other.totalAmount) && this.balance.equals(other.balance) && this.payments.equals(other.payments) && this.trackingCategories.equals(other.trackingCategories) && this.lineItems.equals(other.lineItems) && this.purchaseOrders.equals(other.purchaseOrders) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.contact, this.number, this.issueDate, this.dueDate, this.paidOnDate, this.memo, this.status, this.company, this.currency, this.exchangeRate, this.totalDiscount, this.subTotal, this.totalTaxAmount, this.inclusiveOfTax, this.totalAmount, this.balance, this.payments, this.trackingCategories, this.lineItems, this.purchaseOrders, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<InvoiceRequestType> type = Optional.empty();
        private Optional<InvoiceRequestContact> contact = Optional.empty();
        private Optional<String> number = Optional.empty();
        private Optional<OffsetDateTime> issueDate = Optional.empty();
        private Optional<OffsetDateTime> dueDate = Optional.empty();
        private Optional<OffsetDateTime> paidOnDate = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<InvoiceRequestStatus> status = Optional.empty();
        private Optional<InvoiceRequestCompany> company = Optional.empty();
        private Optional<InvoiceRequestCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Double> totalDiscount = Optional.empty();
        private Optional<Double> subTotal = Optional.empty();
        private Optional<Double> totalTaxAmount = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<Double> balance = Optional.empty();
        private Optional<List<Optional<InvoiceRequestPaymentsItem>>> payments = Optional.empty();
        private Optional<List<Optional<InvoiceRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<List<InvoiceLineItemRequest>> lineItems = Optional.empty();
        private Optional<List<Optional<InvoiceRequestPurchaseOrdersItem>>> purchaseOrders = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceRequest other) {
            this.type(other.getType());
            this.contact(other.getContact());
            this.number(other.getNumber());
            this.issueDate(other.getIssueDate());
            this.dueDate(other.getDueDate());
            this.paidOnDate(other.getPaidOnDate());
            this.memo(other.getMemo());
            this.status(other.getStatus());
            this.company(other.getCompany());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.totalDiscount(other.getTotalDiscount());
            this.subTotal(other.getSubTotal());
            this.totalTaxAmount(other.getTotalTaxAmount());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.totalAmount(other.getTotalAmount());
            this.balance(other.getBalance());
            this.payments(other.getPayments());
            this.trackingCategories(other.getTrackingCategories());
            this.lineItems(other.getLineItems());
            this.purchaseOrders(other.getPurchaseOrders());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<InvoiceRequestType> type) {
            this.type = type;
            return this;
        }

        public Builder type(InvoiceRequestType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<InvoiceRequestContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(InvoiceRequestContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="issue_date", nulls=Nulls.SKIP)
        public Builder issueDate(Optional<OffsetDateTime> issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public Builder issueDate(OffsetDateTime issueDate) {
            this.issueDate = Optional.of(issueDate);
            return this;
        }

        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public Builder dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.of(dueDate);
            return this;
        }

        @JsonSetter(value="paid_on_date", nulls=Nulls.SKIP)
        public Builder paidOnDate(Optional<OffsetDateTime> paidOnDate) {
            this.paidOnDate = paidOnDate;
            return this;
        }

        public Builder paidOnDate(OffsetDateTime paidOnDate) {
            this.paidOnDate = Optional.of(paidOnDate);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<InvoiceRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(InvoiceRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<InvoiceRequestCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(InvoiceRequestCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<InvoiceRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(InvoiceRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="total_discount", nulls=Nulls.SKIP)
        public Builder totalDiscount(Optional<Double> totalDiscount) {
            this.totalDiscount = totalDiscount;
            return this;
        }

        public Builder totalDiscount(Double totalDiscount) {
            this.totalDiscount = Optional.of(totalDiscount);
            return this;
        }

        @JsonSetter(value="sub_total", nulls=Nulls.SKIP)
        public Builder subTotal(Optional<Double> subTotal) {
            this.subTotal = subTotal;
            return this;
        }

        public Builder subTotal(Double subTotal) {
            this.subTotal = Optional.of(subTotal);
            return this;
        }

        @JsonSetter(value="total_tax_amount", nulls=Nulls.SKIP)
        public Builder totalTaxAmount(Optional<Double> totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public Builder totalTaxAmount(Double totalTaxAmount) {
            this.totalTaxAmount = Optional.of(totalTaxAmount);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="balance", nulls=Nulls.SKIP)
        public Builder balance(Optional<Double> balance) {
            this.balance = balance;
            return this;
        }

        public Builder balance(Double balance) {
            this.balance = Optional.of(balance);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Optional<InvoiceRequestPaymentsItem>>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Optional<InvoiceRequestPaymentsItem>> payments) {
            this.payments = Optional.of(payments);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<InvoiceRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<InvoiceRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<InvoiceLineItemRequest>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<InvoiceLineItemRequest> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="purchase_orders", nulls=Nulls.SKIP)
        public Builder purchaseOrders(Optional<List<Optional<InvoiceRequestPurchaseOrdersItem>>> purchaseOrders) {
            this.purchaseOrders = purchaseOrders;
            return this;
        }

        public Builder purchaseOrders(List<Optional<InvoiceRequestPurchaseOrdersItem>> purchaseOrders) {
            this.purchaseOrders = Optional.of(purchaseOrders);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public InvoiceRequest build() {
            return new InvoiceRequest(this.type, this.contact, this.number, this.issueDate, this.dueDate, this.paidOnDate, this.memo, this.status, this.company, this.currency, this.exchangeRate, this.totalDiscount, this.subTotal, this.totalTaxAmount, this.inclusiveOfTax, this.totalAmount, this.balance, this.payments, this.trackingCategories, this.lineItems, this.purchaseOrders, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

