/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.DebugModeLog;
import com.merge.api.resources.accounting.types.ErrorValidationProblem;
import com.merge.api.resources.accounting.types.Invoice;
import com.merge.api.resources.accounting.types.WarningValidationProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceResponse {
    private final Invoice model;
    private final List<WarningValidationProblem> warnings;
    private final List<ErrorValidationProblem> errors;
    private final Optional<List<DebugModeLog>> logs;
    private final Map<String, Object> additionalProperties;

    private InvoiceResponse(Invoice model, List<WarningValidationProblem> warnings, List<ErrorValidationProblem> errors, Optional<List<DebugModeLog>> logs, Map<String, Object> additionalProperties) {
        this.model = model;
        this.warnings = warnings;
        this.errors = errors;
        this.logs = logs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public Invoice getModel() {
        return this.model;
    }

    @JsonProperty(value="warnings")
    public List<WarningValidationProblem> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="errors")
    public List<ErrorValidationProblem> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="logs")
    public Optional<List<DebugModeLog>> getLogs() {
        return this.logs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceResponse && this.equalTo((InvoiceResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceResponse other) {
        return this.model.equals(other.model) && this.warnings.equals(other.warnings) && this.errors.equals(other.errors) && this.logs.equals(other.logs);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.warnings, this.errors, this.logs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    _FinalStage {
        private Invoice model;
        private Optional<List<DebugModeLog>> logs = Optional.empty();
        private List<ErrorValidationProblem> errors = new ArrayList<ErrorValidationProblem>();
        private List<WarningValidationProblem> warnings = new ArrayList<WarningValidationProblem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InvoiceResponse other) {
            this.model(other.getModel());
            this.warnings(other.getWarnings());
            this.errors(other.getErrors());
            this.logs(other.getLogs());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(Invoice model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage logs(List<DebugModeLog> logs) {
            this.logs = Optional.of(logs);
            return this;
        }

        @Override
        @JsonSetter(value="logs", nulls=Nulls.SKIP)
        public _FinalStage logs(Optional<List<DebugModeLog>> logs) {
            this.logs = logs;
            return this;
        }

        @Override
        public _FinalStage addAllErrors(List<ErrorValidationProblem> errors) {
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage addErrors(ErrorValidationProblem errors) {
            this.errors.add(errors);
            return this;
        }

        @Override
        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public _FinalStage errors(List<ErrorValidationProblem> errors) {
            this.errors.clear();
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage addAllWarnings(List<WarningValidationProblem> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public _FinalStage addWarnings(WarningValidationProblem warnings) {
            this.warnings.add(warnings);
            return this;
        }

        @Override
        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public _FinalStage warnings(List<WarningValidationProblem> warnings) {
            this.warnings.clear();
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public InvoiceResponse build() {
            return new InvoiceResponse(this.model, this.warnings, this.errors, this.logs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InvoiceResponse build();

        public _FinalStage warnings(List<WarningValidationProblem> var1);

        public _FinalStage addWarnings(WarningValidationProblem var1);

        public _FinalStage addAllWarnings(List<WarningValidationProblem> var1);

        public _FinalStage errors(List<ErrorValidationProblem> var1);

        public _FinalStage addErrors(ErrorValidationProblem var1);

        public _FinalStage addAllErrors(List<ErrorValidationProblem> var1);

        public _FinalStage logs(Optional<List<DebugModeLog>> var1);

        public _FinalStage logs(List<DebugModeLog> var1);
    }

    public static interface ModelStage {
        public _FinalStage model(Invoice var1);

        public Builder from(InvoiceResponse var1);
    }
}

