/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.ItemCompany;
import com.merge.api.resources.accounting.types.ItemPurchaseAccount;
import com.merge.api.resources.accounting.types.ItemPurchaseTaxRate;
import com.merge.api.resources.accounting.types.ItemSalesAccount;
import com.merge.api.resources.accounting.types.ItemSalesTaxRate;
import com.merge.api.resources.accounting.types.ItemStatus;
import com.merge.api.resources.accounting.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Item {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<ItemStatus> status;
    private final Optional<Double> unitPrice;
    private final Optional<Double> purchasePrice;
    private final Optional<ItemPurchaseAccount> purchaseAccount;
    private final Optional<ItemSalesAccount> salesAccount;
    private final Optional<ItemCompany> company;
    private final Optional<ItemPurchaseTaxRate> purchaseTaxRate;
    private final Optional<ItemSalesTaxRate> salesTaxRate;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Item(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<ItemStatus> status, Optional<Double> unitPrice, Optional<Double> purchasePrice, Optional<ItemPurchaseAccount> purchaseAccount, Optional<ItemSalesAccount> salesAccount, Optional<ItemCompany> company, Optional<ItemPurchaseTaxRate> purchaseTaxRate, Optional<ItemSalesTaxRate> salesTaxRate, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.status = status;
        this.unitPrice = unitPrice;
        this.purchasePrice = purchasePrice;
        this.purchaseAccount = purchaseAccount;
        this.salesAccount = salesAccount;
        this.company = company;
        this.purchaseTaxRate = purchaseTaxRate;
        this.salesTaxRate = salesTaxRate;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="status")
    public Optional<ItemStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="unit_price")
    public Optional<Double> getUnitPrice() {
        return this.unitPrice;
    }

    @JsonProperty(value="purchase_price")
    public Optional<Double> getPurchasePrice() {
        return this.purchasePrice;
    }

    @JsonProperty(value="purchase_account")
    public Optional<ItemPurchaseAccount> getPurchaseAccount() {
        return this.purchaseAccount;
    }

    @JsonProperty(value="sales_account")
    public Optional<ItemSalesAccount> getSalesAccount() {
        return this.salesAccount;
    }

    @JsonProperty(value="company")
    public Optional<ItemCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="purchase_tax_rate")
    public Optional<ItemPurchaseTaxRate> getPurchaseTaxRate() {
        return this.purchaseTaxRate;
    }

    @JsonProperty(value="sales_tax_rate")
    public Optional<ItemSalesTaxRate> getSalesTaxRate() {
        return this.salesTaxRate;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Item && this.equalTo((Item)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Item other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.status.equals(other.status) && this.unitPrice.equals(other.unitPrice) && this.purchasePrice.equals(other.purchasePrice) && this.purchaseAccount.equals(other.purchaseAccount) && this.salesAccount.equals(other.salesAccount) && this.company.equals(other.company) && this.purchaseTaxRate.equals(other.purchaseTaxRate) && this.salesTaxRate.equals(other.salesTaxRate) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.status, this.unitPrice, this.purchasePrice, this.purchaseAccount, this.salesAccount, this.company, this.purchaseTaxRate, this.salesTaxRate, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<ItemStatus> status = Optional.empty();
        private Optional<Double> unitPrice = Optional.empty();
        private Optional<Double> purchasePrice = Optional.empty();
        private Optional<ItemPurchaseAccount> purchaseAccount = Optional.empty();
        private Optional<ItemSalesAccount> salesAccount = Optional.empty();
        private Optional<ItemCompany> company = Optional.empty();
        private Optional<ItemPurchaseTaxRate> purchaseTaxRate = Optional.empty();
        private Optional<ItemSalesTaxRate> salesTaxRate = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Item other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.status(other.getStatus());
            this.unitPrice(other.getUnitPrice());
            this.purchasePrice(other.getPurchasePrice());
            this.purchaseAccount(other.getPurchaseAccount());
            this.salesAccount(other.getSalesAccount());
            this.company(other.getCompany());
            this.purchaseTaxRate(other.getPurchaseTaxRate());
            this.salesTaxRate(other.getSalesTaxRate());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<ItemStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ItemStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="unit_price", nulls=Nulls.SKIP)
        public Builder unitPrice(Optional<Double> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public Builder unitPrice(Double unitPrice) {
            this.unitPrice = Optional.of(unitPrice);
            return this;
        }

        @JsonSetter(value="purchase_price", nulls=Nulls.SKIP)
        public Builder purchasePrice(Optional<Double> purchasePrice) {
            this.purchasePrice = purchasePrice;
            return this;
        }

        public Builder purchasePrice(Double purchasePrice) {
            this.purchasePrice = Optional.of(purchasePrice);
            return this;
        }

        @JsonSetter(value="purchase_account", nulls=Nulls.SKIP)
        public Builder purchaseAccount(Optional<ItemPurchaseAccount> purchaseAccount) {
            this.purchaseAccount = purchaseAccount;
            return this;
        }

        public Builder purchaseAccount(ItemPurchaseAccount purchaseAccount) {
            this.purchaseAccount = Optional.of(purchaseAccount);
            return this;
        }

        @JsonSetter(value="sales_account", nulls=Nulls.SKIP)
        public Builder salesAccount(Optional<ItemSalesAccount> salesAccount) {
            this.salesAccount = salesAccount;
            return this;
        }

        public Builder salesAccount(ItemSalesAccount salesAccount) {
            this.salesAccount = Optional.of(salesAccount);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<ItemCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(ItemCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="purchase_tax_rate", nulls=Nulls.SKIP)
        public Builder purchaseTaxRate(Optional<ItemPurchaseTaxRate> purchaseTaxRate) {
            this.purchaseTaxRate = purchaseTaxRate;
            return this;
        }

        public Builder purchaseTaxRate(ItemPurchaseTaxRate purchaseTaxRate) {
            this.purchaseTaxRate = Optional.of(purchaseTaxRate);
            return this;
        }

        @JsonSetter(value="sales_tax_rate", nulls=Nulls.SKIP)
        public Builder salesTaxRate(Optional<ItemSalesTaxRate> salesTaxRate) {
            this.salesTaxRate = salesTaxRate;
            return this;
        }

        public Builder salesTaxRate(ItemSalesTaxRate salesTaxRate) {
            this.salesTaxRate = Optional.of(salesTaxRate);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Item build() {
            return new Item(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.status, this.unitPrice, this.purchasePrice, this.purchaseAccount, this.salesAccount, this.company, this.purchaseTaxRate, this.salesTaxRate, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

