/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.JournalEntryAccountingPeriod;
import com.merge.api.resources.accounting.types.JournalEntryAppliedPaymentsItem;
import com.merge.api.resources.accounting.types.JournalEntryCompany;
import com.merge.api.resources.accounting.types.JournalEntryCurrency;
import com.merge.api.resources.accounting.types.JournalEntryPaymentsItem;
import com.merge.api.resources.accounting.types.JournalEntryPostingStatus;
import com.merge.api.resources.accounting.types.JournalEntryTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.JournalLine;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JournalEntry {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<List<Optional<JournalEntryPaymentsItem>>> payments;
    private final Optional<List<Optional<JournalEntryAppliedPaymentsItem>>> appliedPayments;
    private final Optional<String> memo;
    private final Optional<JournalEntryCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<JournalEntryCompany> company;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<List<JournalLine>> lines;
    private final Optional<String> journalNumber;
    private final Optional<List<Optional<JournalEntryTrackingCategoriesItem>>> trackingCategories;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<JournalEntryPostingStatus> postingStatus;
    private final Optional<JournalEntryAccountingPeriod> accountingPeriod;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private JournalEntry(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<OffsetDateTime> transactionDate, Optional<List<Optional<JournalEntryPaymentsItem>>> payments, Optional<List<Optional<JournalEntryAppliedPaymentsItem>>> appliedPayments, Optional<String> memo, Optional<JournalEntryCurrency> currency, Optional<String> exchangeRate, Optional<JournalEntryCompany> company, Optional<Boolean> inclusiveOfTax, Optional<List<JournalLine>> lines, Optional<String> journalNumber, Optional<List<Optional<JournalEntryTrackingCategoriesItem>>> trackingCategories, Optional<Boolean> remoteWasDeleted, Optional<JournalEntryPostingStatus> postingStatus, Optional<JournalEntryAccountingPeriod> accountingPeriod, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.transactionDate = transactionDate;
        this.payments = payments;
        this.appliedPayments = appliedPayments;
        this.memo = memo;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.inclusiveOfTax = inclusiveOfTax;
        this.lines = lines;
        this.journalNumber = journalNumber;
        this.trackingCategories = trackingCategories;
        this.remoteWasDeleted = remoteWasDeleted;
        this.postingStatus = postingStatus;
        this.accountingPeriod = accountingPeriod;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="payments")
    public Optional<List<Optional<JournalEntryPaymentsItem>>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="applied_payments")
    public Optional<List<Optional<JournalEntryAppliedPaymentsItem>>> getAppliedPayments() {
        return this.appliedPayments;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="currency")
    public Optional<JournalEntryCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<JournalEntryCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="lines")
    public Optional<List<JournalLine>> getLines() {
        return this.lines;
    }

    @JsonProperty(value="journal_number")
    public Optional<String> getJournalNumber() {
        return this.journalNumber;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<JournalEntryTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="posting_status")
    public Optional<JournalEntryPostingStatus> getPostingStatus() {
        return this.postingStatus;
    }

    @JsonProperty(value="accounting_period")
    public Optional<JournalEntryAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JournalEntry && this.equalTo((JournalEntry)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JournalEntry other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.transactionDate.equals(other.transactionDate) && this.payments.equals(other.payments) && this.appliedPayments.equals(other.appliedPayments) && this.memo.equals(other.memo) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.lines.equals(other.lines) && this.journalNumber.equals(other.journalNumber) && this.trackingCategories.equals(other.trackingCategories) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.postingStatus.equals(other.postingStatus) && this.accountingPeriod.equals(other.accountingPeriod) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.payments, this.appliedPayments, this.memo, this.currency, this.exchangeRate, this.company, this.inclusiveOfTax, this.lines, this.journalNumber, this.trackingCategories, this.remoteWasDeleted, this.postingStatus, this.accountingPeriod, this.remoteCreatedAt, this.remoteUpdatedAt, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<List<Optional<JournalEntryPaymentsItem>>> payments = Optional.empty();
        private Optional<List<Optional<JournalEntryAppliedPaymentsItem>>> appliedPayments = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<JournalEntryCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<JournalEntryCompany> company = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<List<JournalLine>> lines = Optional.empty();
        private Optional<String> journalNumber = Optional.empty();
        private Optional<List<Optional<JournalEntryTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<JournalEntryPostingStatus> postingStatus = Optional.empty();
        private Optional<JournalEntryAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JournalEntry other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.transactionDate(other.getTransactionDate());
            this.payments(other.getPayments());
            this.appliedPayments(other.getAppliedPayments());
            this.memo(other.getMemo());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.lines(other.getLines());
            this.journalNumber(other.getJournalNumber());
            this.trackingCategories(other.getTrackingCategories());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.postingStatus(other.getPostingStatus());
            this.accountingPeriod(other.getAccountingPeriod());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Optional<JournalEntryPaymentsItem>>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Optional<JournalEntryPaymentsItem>> payments) {
            this.payments = Optional.of(payments);
            return this;
        }

        @JsonSetter(value="applied_payments", nulls=Nulls.SKIP)
        public Builder appliedPayments(Optional<List<Optional<JournalEntryAppliedPaymentsItem>>> appliedPayments) {
            this.appliedPayments = appliedPayments;
            return this;
        }

        public Builder appliedPayments(List<Optional<JournalEntryAppliedPaymentsItem>> appliedPayments) {
            this.appliedPayments = Optional.of(appliedPayments);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<JournalEntryCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(JournalEntryCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<JournalEntryCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(JournalEntryCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public Builder lines(Optional<List<JournalLine>> lines) {
            this.lines = lines;
            return this;
        }

        public Builder lines(List<JournalLine> lines) {
            this.lines = Optional.of(lines);
            return this;
        }

        @JsonSetter(value="journal_number", nulls=Nulls.SKIP)
        public Builder journalNumber(Optional<String> journalNumber) {
            this.journalNumber = journalNumber;
            return this;
        }

        public Builder journalNumber(String journalNumber) {
            this.journalNumber = Optional.of(journalNumber);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<JournalEntryTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<JournalEntryTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="posting_status", nulls=Nulls.SKIP)
        public Builder postingStatus(Optional<JournalEntryPostingStatus> postingStatus) {
            this.postingStatus = postingStatus;
            return this;
        }

        public Builder postingStatus(JournalEntryPostingStatus postingStatus) {
            this.postingStatus = Optional.of(postingStatus);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<JournalEntryAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(JournalEntryAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public JournalEntry build() {
            return new JournalEntry(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.payments, this.appliedPayments, this.memo, this.currency, this.exchangeRate, this.company, this.inclusiveOfTax, this.lines, this.journalNumber, this.trackingCategories, this.remoteWasDeleted, this.postingStatus, this.accountingPeriod, this.remoteCreatedAt, this.remoteUpdatedAt, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

