/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.JournalEntryRequestCompany;
import com.merge.api.resources.accounting.types.JournalEntryRequestCurrency;
import com.merge.api.resources.accounting.types.JournalEntryRequestPaymentsItem;
import com.merge.api.resources.accounting.types.JournalEntryRequestPostingStatus;
import com.merge.api.resources.accounting.types.JournalEntryRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.JournalLineRequest;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JournalEntryRequest {
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<List<Optional<JournalEntryRequestPaymentsItem>>> payments;
    private final Optional<String> memo;
    private final Optional<JournalEntryRequestCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<JournalEntryRequestCompany> company;
    private final Optional<List<Optional<JournalEntryRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<List<JournalLineRequest>> lines;
    private final Optional<String> journalNumber;
    private final Optional<JournalEntryRequestPostingStatus> postingStatus;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private JournalEntryRequest(Optional<OffsetDateTime> transactionDate, Optional<List<Optional<JournalEntryRequestPaymentsItem>>> payments, Optional<String> memo, Optional<JournalEntryRequestCurrency> currency, Optional<String> exchangeRate, Optional<JournalEntryRequestCompany> company, Optional<List<Optional<JournalEntryRequestTrackingCategoriesItem>>> trackingCategories, Optional<Boolean> inclusiveOfTax, Optional<List<JournalLineRequest>> lines, Optional<String> journalNumber, Optional<JournalEntryRequestPostingStatus> postingStatus, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.transactionDate = transactionDate;
        this.payments = payments;
        this.memo = memo;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.trackingCategories = trackingCategories;
        this.inclusiveOfTax = inclusiveOfTax;
        this.lines = lines;
        this.journalNumber = journalNumber;
        this.postingStatus = postingStatus;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="payments")
    public Optional<List<Optional<JournalEntryRequestPaymentsItem>>> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="currency")
    public Optional<JournalEntryRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<JournalEntryRequestCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<JournalEntryRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="lines")
    public Optional<List<JournalLineRequest>> getLines() {
        return this.lines;
    }

    @JsonProperty(value="journal_number")
    public Optional<String> getJournalNumber() {
        return this.journalNumber;
    }

    @JsonProperty(value="posting_status")
    public Optional<JournalEntryRequestPostingStatus> getPostingStatus() {
        return this.postingStatus;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JournalEntryRequest && this.equalTo((JournalEntryRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JournalEntryRequest other) {
        return this.transactionDate.equals(other.transactionDate) && this.payments.equals(other.payments) && this.memo.equals(other.memo) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.trackingCategories.equals(other.trackingCategories) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.lines.equals(other.lines) && this.journalNumber.equals(other.journalNumber) && this.postingStatus.equals(other.postingStatus) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.transactionDate, this.payments, this.memo, this.currency, this.exchangeRate, this.company, this.trackingCategories, this.inclusiveOfTax, this.lines, this.journalNumber, this.postingStatus, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<List<Optional<JournalEntryRequestPaymentsItem>>> payments = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<JournalEntryRequestCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<JournalEntryRequestCompany> company = Optional.empty();
        private Optional<List<Optional<JournalEntryRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<List<JournalLineRequest>> lines = Optional.empty();
        private Optional<String> journalNumber = Optional.empty();
        private Optional<JournalEntryRequestPostingStatus> postingStatus = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JournalEntryRequest other) {
            this.transactionDate(other.getTransactionDate());
            this.payments(other.getPayments());
            this.memo(other.getMemo());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.trackingCategories(other.getTrackingCategories());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.lines(other.getLines());
            this.journalNumber(other.getJournalNumber());
            this.postingStatus(other.getPostingStatus());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="payments", nulls=Nulls.SKIP)
        public Builder payments(Optional<List<Optional<JournalEntryRequestPaymentsItem>>> payments) {
            this.payments = payments;
            return this;
        }

        public Builder payments(List<Optional<JournalEntryRequestPaymentsItem>> payments) {
            this.payments = Optional.of(payments);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<JournalEntryRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(JournalEntryRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<JournalEntryRequestCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(JournalEntryRequestCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<JournalEntryRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<JournalEntryRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public Builder lines(Optional<List<JournalLineRequest>> lines) {
            this.lines = lines;
            return this;
        }

        public Builder lines(List<JournalLineRequest> lines) {
            this.lines = Optional.of(lines);
            return this;
        }

        @JsonSetter(value="journal_number", nulls=Nulls.SKIP)
        public Builder journalNumber(Optional<String> journalNumber) {
            this.journalNumber = journalNumber;
            return this;
        }

        public Builder journalNumber(String journalNumber) {
            this.journalNumber = Optional.of(journalNumber);
            return this;
        }

        @JsonSetter(value="posting_status", nulls=Nulls.SKIP)
        public Builder postingStatus(Optional<JournalEntryRequestPostingStatus> postingStatus) {
            this.postingStatus = postingStatus;
            return this;
        }

        public Builder postingStatus(JournalEntryRequestPostingStatus postingStatus) {
            this.postingStatus = Optional.of(postingStatus);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public JournalEntryRequest build() {
            return new JournalEntryRequest(this.transactionDate, this.payments, this.memo, this.currency, this.exchangeRate, this.company, this.trackingCategories, this.inclusiveOfTax, this.lines, this.journalNumber, this.postingStatus, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

