/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.JournalLineRequestAccount;
import com.merge.api.resources.accounting.types.JournalLineRequestCurrency;
import com.merge.api.resources.accounting.types.JournalLineRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.JournalLineRequestTrackingCategory;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JournalLineRequest {
    private final Optional<String> remoteId;
    private final Optional<JournalLineRequestAccount> account;
    private final Optional<Double> netAmount;
    private final Optional<JournalLineRequestTrackingCategory> trackingCategory;
    private final Optional<List<Optional<JournalLineRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<JournalLineRequestCurrency> currency;
    private final Optional<String> company;
    private final Optional<String> contact;
    private final Optional<String> taxRate;
    private final Optional<String> description;
    private final Optional<String> exchangeRate;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private JournalLineRequest(Optional<String> remoteId, Optional<JournalLineRequestAccount> account, Optional<Double> netAmount, Optional<JournalLineRequestTrackingCategory> trackingCategory, Optional<List<Optional<JournalLineRequestTrackingCategoriesItem>>> trackingCategories, Optional<JournalLineRequestCurrency> currency, Optional<String> company, Optional<String> contact, Optional<String> taxRate, Optional<String> description, Optional<String> exchangeRate, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.remoteId = remoteId;
        this.account = account;
        this.netAmount = netAmount;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.currency = currency;
        this.company = company;
        this.contact = contact;
        this.taxRate = taxRate;
        this.description = description;
        this.exchangeRate = exchangeRate;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="account")
    public Optional<JournalLineRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="net_amount")
    public Optional<Double> getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="tracking_category")
    public Optional<JournalLineRequestTrackingCategory> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<JournalLineRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="currency")
    public Optional<JournalLineRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="contact")
    public Optional<String> getContact() {
        return this.contact;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JournalLineRequest && this.equalTo((JournalLineRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JournalLineRequest other) {
        return this.remoteId.equals(other.remoteId) && this.account.equals(other.account) && this.netAmount.equals(other.netAmount) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.currency.equals(other.currency) && this.company.equals(other.company) && this.contact.equals(other.contact) && this.taxRate.equals(other.taxRate) && this.description.equals(other.description) && this.exchangeRate.equals(other.exchangeRate) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.remoteId, this.account, this.netAmount, this.trackingCategory, this.trackingCategories, this.currency, this.company, this.contact, this.taxRate, this.description, this.exchangeRate, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> remoteId = Optional.empty();
        private Optional<JournalLineRequestAccount> account = Optional.empty();
        private Optional<Double> netAmount = Optional.empty();
        private Optional<JournalLineRequestTrackingCategory> trackingCategory = Optional.empty();
        private Optional<List<Optional<JournalLineRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<JournalLineRequestCurrency> currency = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<String> contact = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JournalLineRequest other) {
            this.remoteId(other.getRemoteId());
            this.account(other.getAccount());
            this.netAmount(other.getNetAmount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.currency(other.getCurrency());
            this.company(other.getCompany());
            this.contact(other.getContact());
            this.taxRate(other.getTaxRate());
            this.description(other.getDescription());
            this.exchangeRate(other.getExchangeRate());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<JournalLineRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(JournalLineRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="net_amount", nulls=Nulls.SKIP)
        public Builder netAmount(Optional<Double> netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder netAmount(Double netAmount) {
            this.netAmount = Optional.of(netAmount);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<JournalLineRequestTrackingCategory> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(JournalLineRequestTrackingCategory trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<JournalLineRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<JournalLineRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<JournalLineRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(JournalLineRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<String> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(String contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public JournalLineRequest build() {
            return new JournalLineRequest(this.remoteId, this.account, this.netAmount, this.trackingCategory, this.trackingCategories, this.currency, this.company, this.contact, this.taxRate, this.description, this.exchangeRate, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

