/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LinkToken {
    private final String linkToken;
    private final Optional<String> integrationName;
    private final Optional<String> magicLinkUrl;
    private final Map<String, Object> additionalProperties;

    private LinkToken(String linkToken, Optional<String> integrationName, Optional<String> magicLinkUrl, Map<String, Object> additionalProperties) {
        this.linkToken = linkToken;
        this.integrationName = integrationName;
        this.magicLinkUrl = magicLinkUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="link_token")
    public String getLinkToken() {
        return this.linkToken;
    }

    @JsonProperty(value="integration_name")
    public Optional<String> getIntegrationName() {
        return this.integrationName;
    }

    @JsonProperty(value="magic_link_url")
    public Optional<String> getMagicLinkUrl() {
        return this.magicLinkUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkToken && this.equalTo((LinkToken)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkToken other) {
        return this.linkToken.equals(other.linkToken) && this.integrationName.equals(other.integrationName) && this.magicLinkUrl.equals(other.magicLinkUrl);
    }

    public int hashCode() {
        return Objects.hash(this.linkToken, this.integrationName, this.magicLinkUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LinkTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LinkTokenStage,
    _FinalStage {
        private String linkToken;
        private Optional<String> magicLinkUrl = Optional.empty();
        private Optional<String> integrationName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LinkToken other) {
            this.linkToken(other.getLinkToken());
            this.integrationName(other.getIntegrationName());
            this.magicLinkUrl(other.getMagicLinkUrl());
            return this;
        }

        @Override
        @JsonSetter(value="link_token")
        public _FinalStage linkToken(String linkToken) {
            this.linkToken = linkToken;
            return this;
        }

        @Override
        public _FinalStage magicLinkUrl(String magicLinkUrl) {
            this.magicLinkUrl = Optional.of(magicLinkUrl);
            return this;
        }

        @Override
        @JsonSetter(value="magic_link_url", nulls=Nulls.SKIP)
        public _FinalStage magicLinkUrl(Optional<String> magicLinkUrl) {
            this.magicLinkUrl = magicLinkUrl;
            return this;
        }

        @Override
        public _FinalStage integrationName(String integrationName) {
            this.integrationName = Optional.of(integrationName);
            return this;
        }

        @Override
        @JsonSetter(value="integration_name", nulls=Nulls.SKIP)
        public _FinalStage integrationName(Optional<String> integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        @Override
        public LinkToken build() {
            return new LinkToken(this.linkToken, this.integrationName, this.magicLinkUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LinkToken build();

        public _FinalStage integrationName(Optional<String> var1);

        public _FinalStage integrationName(String var1);

        public _FinalStage magicLinkUrl(Optional<String> var1);

        public _FinalStage magicLinkUrl(String var1);
    }

    public static interface LinkTokenStage {
        public _FinalStage linkToken(String var1);

        public Builder from(LinkToken var1);
    }
}

